/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.ErrorTypeHandlerConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.PoolingConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.ReconnectableConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.config.ConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class DefaultConnectionProviderObjectBuilder<C>
extends ConnectionProviderObjectBuilder<C> {
    DefaultConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, ConnectionManagerAdapter connectionManager, ExtensionModel extensionModel, MuleContext muleContext) {
        super(providerModel, resolverSet, connectionManager, extensionModel, muleContext);
    }

    public DefaultConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, boolean disableValidation, RetryPolicyTemplate retryPolicyTemplate, ConnectionManagerAdapter connectionManager, ExtensionModel extensionModel, MuleContext muleContext) {
        super(providerModel, resolverSet, poolingProfile, disableValidation, retryPolicyTemplate, connectionManager, extensionModel, muleContext);
    }

    @Override
    public final ConnectionProvider<C> build(ResolverSetResult result) throws MuleException {
        ConnectionProvider<C> provider = this.doBuild(result);
        provider = this.applyConnectionManagement(provider);
        provider = this.applyErrorHandling(provider);
        return provider;
    }

    protected ConnectionProvider<C> doBuild(ResolverSetResult result) throws MuleException {
        ConnectionProvider provider = (ConnectionProvider)super.build(result);
        MuleExtensionUtils.injectConfigName((EnrichableModel)this.providerModel, provider, this.ownerConfigName);
        return provider;
    }

    private ConnectionProvider<C> applyErrorHandling(ConnectionProvider<C> provider) {
        provider = new ErrorTypeHandlerConnectionProviderWrapper(provider, this.muleContext, this.extensionModel, this.retryPolicyTemplate);
        return provider;
    }

    private ConnectionProvider<C> applyConnectionManagement(ConnectionProvider<C> provider) {
        ConnectionManagementType connectionManagementType = this.providerModel.getConnectionManagementType();
        provider = connectionManagementType == ConnectionManagementType.POOLING ? new PoolingConnectionProviderWrapper((ConnectionProvider)provider, this.poolingProfile, this.disableValidation, this.retryPolicyTemplate) : new ReconnectableConnectionProviderWrapper(provider, this.disableValidation, this.retryPolicyTemplate);
        return provider;
    }
}

