/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.manifest;

import java.util.Optional;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.manifest.ExtensionManifestBuilder;
import org.mule.runtime.extension.api.persistence.manifest.ExtensionManifestXmlSerializer;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.resources.manifest.ExportedArtifactsCollector;

public final class ExtensionManifestGenerator
implements GeneratedResourceFactory {
    public Optional<GeneratedResource> generateResource(ExtensionModel extensionModel) {
        Optional typeProperty = extensionModel.getModelProperty(ImplementingTypeModelProperty.class);
        if (!typeProperty.isPresent()) {
            return Optional.empty();
        }
        ExportedArtifactsCollector exportCollector = new ExportedArtifactsCollector(extensionModel);
        ExtensionManifestBuilder builder = new ExtensionManifestBuilder();
        builder.setName(extensionModel.getName()).setDescription(extensionModel.getDescription()).setVersion(extensionModel.getVersion()).setMinMuleVersion(extensionModel.getMinMuleVersion()).addExportedPackages(exportCollector.getExportedPackages()).addExportedResources(exportCollector.getExportedResources()).withDescriber().setId("java").addProperty("type", ((ImplementingTypeModelProperty)typeProperty.get()).getType().getName());
        String manifestXml = new ExtensionManifestXmlSerializer().serialize(builder.build());
        return Optional.of(new GeneratedResource("extension-manifest.xml", manifestXml.getBytes()));
    }
}

