/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.ErrorsModelFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.MethodWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ErrorsDeclarationEnricher
implements DeclarationEnricher {
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ErrorTypeDefinition[] errorTypes;
        ExtensionTypeWrapper extensionElement;
        Optional<ErrorTypes> errorAnnotation;
        final LoadingCache typeWrapperCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, TypeWrapper>(){

            public TypeWrapper load(Class<?> clazz) throws Exception {
                return new TypeWrapper(clazz);
            }
        });
        ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        Optional implementingType = declaration.getModelProperty(ImplementingTypeModelProperty.class);
        String extensionNamespace = MuleExtensionUtils.getExtensionsErrorNamespace(declaration);
        ErrorsModelFactory errorModelDescriber = new ErrorsModelFactory(extensionNamespace);
        errorModelDescriber.getErrorModels().forEach(arg_0 -> ((ExtensionDeclaration)declaration).addErrorModel(arg_0));
        if (implementingType.isPresent() && (errorAnnotation = (extensionElement = new ExtensionTypeWrapper(((ImplementingTypeModelProperty)implementingType.get()).getType())).getAnnotation(ErrorTypes.class)).isPresent() && (errorTypes = (ErrorTypeDefinition[])errorAnnotation.get().value().getEnumConstants()).length > 0) {
            final ErrorsModelFactory operationErrorModelDescriber = new ErrorsModelFactory(errorTypes, extensionNamespace);
            operationErrorModelDescriber.getErrorModels().forEach(arg_0 -> ((ExtensionDeclaration)declaration).addErrorModel(arg_0));
            new IdempotentDeclarationWalker(){

                public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                    Optional modelProperty = declaration.getModelProperty(ImplementingMethodModelProperty.class);
                    if (modelProperty.isPresent()) {
                        MethodWrapper methodElement = new MethodWrapper(((ImplementingMethodModelProperty)modelProperty.get()).getMethod());
                        ErrorsDeclarationEnricher.this.registerOperationErrorTypes(methodElement, declaration, operationErrorModelDescriber, errorTypes, extensionElement, typeWrapperCache);
                    }
                }
            }.walk(declaration);
        }
    }

    private void registerOperationErrorTypes(MethodElement operationMethod, OperationDeclaration operation, ErrorsModelFactory errorModelDescriber, ErrorTypeDefinition<?>[] extensionErrorTypes, ExtensionElement extensionElement, LoadingCache<Class<?>, TypeWrapper> typeWrapperCache) {
        this.getOperationThrowsDeclaration(operationMethod, extensionElement, typeWrapperCache).ifPresent(throwsAnnotation -> {
            Class[] providers = throwsAnnotation.value();
            Stream.of(providers).forEach(provider -> {
                try {
                    ErrorTypeProvider errorTypeProvider = (ErrorTypeProvider)provider.newInstance();
                    errorTypeProvider.getErrorTypes().stream().map(error -> this.validateOperationThrows(extensionErrorTypes, (ErrorTypeDefinition)error)).map(errorModelDescriber::getErrorModel).forEach(arg_0 -> ((OperationDeclaration)operation).addErrorModel(arg_0));
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create ErrorTypeProvider of type " + provider.getName())), (Throwable)e);
                }
            });
        });
    }

    private Optional<Throws> getOperationThrowsDeclaration(MethodElement operationMethod, ExtensionElement extensionElement, LoadingCache<Class<?>, TypeWrapper> typeWrapperCache) {
        TypeWrapper operationContainer = (TypeWrapper)typeWrapperCache.getUnchecked((Object)operationMethod.getDeclaringClass());
        return Optional.ofNullable(operationMethod.getAnnotation(Throws.class).orElseGet(() -> operationContainer.getAnnotation(Throws.class).orElseGet(() -> extensionElement.getAnnotation(Throws.class).orElse(null))));
    }

    private ErrorTypeDefinition validateOperationThrows(ErrorTypeDefinition<?>[] errorTypes, ErrorTypeDefinition error) {
        Class<?> extensionErrorType = errorTypes.getClass().getComponentType();
        if (error.getClass().equals(MuleErrors.class)) {
            return error;
        }
        if (!error.getClass().equals(extensionErrorType) && !error.getClass().getSuperclass().equals(extensionErrorType)) {
            throw new IllegalModelDefinitionException(String.format("Invalid operation throws detected, the extension declared to throw errors of %s type, but an error of %s type has been detected", extensionErrorType, error.getClass()));
        }
        return error;
    }
}

