/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.resolver;

import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingUtils;
import org.mule.runtime.module.extension.internal.config.dsl.object.CharsetValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.DefaultValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.MediaTypeValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.ValueResolverParsingDelegate;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;

public class ValueResolverFactoryTypeVisitor
extends BasicTypeMetadataVisitor {
    private final ConversionService conversionService = new DefaultConversionService();
    private final List<ValueResolverParsingDelegate> valueResolverParsingDelegates = ImmutableList.of((Object)new CharsetValueResolverParsingDelegate(), (Object)new MediaTypeValueResolverParsingDelegate());
    private final ValueResolverParsingDelegate defaultValueResolverParsingDelegate = new DefaultValueResolverParsingDelegate();
    private final Reference<ValueResolver> resolverValueHolder = new Reference();
    private DslSyntaxResolver dslSyntaxResolver;
    private final String parameterName;
    private final MetadataType expected;
    private final Object value;
    private final Object defaultValue;
    private final boolean acceptsReferences;
    private final Class<?> expectedClass;

    public ValueResolverFactoryTypeVisitor(DslSyntaxResolver dslSyntaxResolver, String parameterName, MetadataType expected, Object value, Object defaultValue, boolean acceptsReferences, Class<?> expectedClass) {
        this.dslSyntaxResolver = dslSyntaxResolver;
        this.parameterName = parameterName;
        this.expected = expected;
        this.value = value;
        this.defaultValue = defaultValue;
        this.acceptsReferences = acceptsReferences;
        this.expectedClass = expectedClass;
    }

    public ValueResolver getResolver() {
        return (ValueResolver)this.resolverValueHolder.get();
    }

    protected void visitBasicType(MetadataType metadataType) {
        if (this.conversionService.canConvert(this.value.getClass(), this.expectedClass)) {
            this.resolverValueHolder.set((Object)new StaticValueResolver(this.convertSimpleValue(this.value, this.expectedClass, this.parameterName)));
        } else {
            this.defaultVisit(metadataType);
        }
    }

    public void visitDateTime(DateTimeType dateTimeType) {
        this.resolverValueHolder.set((Object)this.parseDate(this.value, (MetadataType)dateTimeType, this.defaultValue));
    }

    public void visitDate(DateType dateType) {
        this.resolverValueHolder.set((Object)this.parseDate(this.value, (MetadataType)dateType, this.defaultValue));
    }

    public void visitObject(ObjectType objectType) {
        if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
            this.defaultVisit((MetadataType)objectType);
            return;
        }
        Optional delegate = ExtensionParsingUtils.locateParsingDelegate(this.valueResolverParsingDelegates, objectType);
        Optional typeDsl = this.dslSyntaxResolver.resolve((MetadataType)objectType);
        Object valueResolver = delegate.isPresent() && typeDsl.isPresent() ? (ValueResolver)delegate.get().parse(this.value.toString(), objectType, (DslElementSyntax)typeDsl.get()) : (this.acceptsReferences ? (ValueResolver)this.defaultValueResolverParsingDelegate.parse(this.value.toString(), objectType, null) : new StaticValueResolver(this.value));
        this.resolverValueHolder.set(valueResolver);
    }

    protected void defaultVisit(MetadataType metadataType) {
        ValueResolver delegateResolver = ExtensionParsingUtils.locateParsingDelegate(this.valueResolverParsingDelegates, metadataType).map(delegate -> (ValueResolver)delegate.parse(this.value.toString(), metadataType, null)).orElseGet(() -> this.acceptsReferences ? (ValueResolver)this.defaultValueResolverParsingDelegate.parse(this.value.toString(), metadataType, null) : new TypeSafeValueResolverWrapper((ValueResolver)new StaticValueResolver(this.value), this.expectedClass));
        this.resolverValueHolder.set((Object)delegateResolver);
    }

    private ValueResolver parseDate(Object value, MetadataType dateType, Object defaultValue) {
        Class type = JavaTypeUtils.getType((MetadataType)dateType);
        if (MuleExtensionUtils.isExpression((Object)value)) {
            return new TypeSafeExpressionValueResolver((String)value, type, IntrospectionUtils.toDataType((MetadataType)dateType));
        }
        if (value == null) {
            if (defaultValue == null) {
                return new StaticValueResolver(null);
            }
            value = defaultValue;
        }
        return this.doParseDate(value, type);
    }

    private Object convertSimpleValue(Object value, Class<?> expectedClass, String parameterName) {
        try {
            return this.conversionService.convert(value, expectedClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not transform simple value '%s' to type '%s' in parameter '%s'", value, expectedClass.getSimpleName(), parameterName));
        }
    }

    private ValueResolver doParseDate(Object value, Class<?> type) {
        if (value instanceof String) {
            Comparable<Date> constructedValue = null;
            DateTime dateTime = this.getParsedDateTime((String)value);
            if (type.equals(LocalDate.class)) {
                constructedValue = LocalDate.of(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth());
            } else if (type.equals(Date.class)) {
                constructedValue = dateTime.toDate();
            } else if (type.equals(LocalDateTime.class)) {
                Instant instant = Instant.ofEpochMilli(dateTime.getMillis());
                constructedValue = LocalDateTime.ofInstant(instant, ZoneId.of(dateTime.getZone().getID()));
            } else if (type.equals(Calendar.class)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dateTime.toDate());
                constructedValue = calendar;
            }
            if (constructedValue == null) {
                throw new IllegalArgumentException(String.format("Could not construct value of type '%s' from String '%s'", type.getName(), value));
            }
            value = constructedValue;
        }
        if (value instanceof Date || value instanceof LocalDate || value instanceof LocalDateTime || value instanceof Calendar) {
            return new StaticValueResolver(value);
        }
        throw new IllegalArgumentException(String.format("Could not transform value of type '%s' to a valid date type", value != null ? value.getClass().getName() : "null"));
    }

    private DateTime getParsedDateTime(String value) {
        try {
            return ISODateTimeFormat.dateTimeParser().withOffsetParsed().parseDateTime(value);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(String.format("Could not parse value '%s' according to ISO 8601", value));
        }
    }
}

