/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.loader;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.runtime.config.ConfigurationFactory;
import org.mule.runtime.extension.api.soap.MessageDispatcherProvider;
import org.mule.runtime.module.extension.api.loader.ModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.enricher.ErrorsModelFactory;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.TypeAwareConfigurationFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigurationFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.soap.internal.loader.SoapExtensionTypeFactory;
import org.mule.runtime.module.extension.soap.internal.loader.SoapInvokeOperationDeclarer;
import org.mule.runtime.module.extension.soap.internal.loader.SoapServiceProviderDeclarer;
import org.mule.runtime.module.extension.soap.internal.loader.property.SoapExtensionModelProperty;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.MessageDispatcherProviderTypeWrapper;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.SoapExtensionTypeWrapper;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.SoapServiceProviderWrapper;
import org.mule.runtime.soap.api.exception.error.SoapErrors;

public final class SoapModelLoaderDelegate
implements ModelLoaderDelegate {
    private final SoapInvokeOperationDeclarer operationDeclarer;
    private final SoapServiceProviderDeclarer serviceProviderDeclarer;
    private final Class<?> extensionType;
    private final String version;
    private final ClassTypeLoader typeLoader;

    public SoapModelLoaderDelegate(Class<?> extensionType, String version) {
        this.extensionType = extensionType;
        this.version = version;
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        this.serviceProviderDeclarer = new SoapServiceProviderDeclarer(this.typeLoader);
        this.operationDeclarer = new SoapInvokeOperationDeclarer();
    }

    public ExtensionDeclarer declare(ExtensionLoadingContext context) {
        SoapExtensionTypeWrapper extension = SoapExtensionTypeFactory.getSoapExtensionType(this.extensionType);
        List<MessageDispatcherProviderTypeWrapper> customTransportProviders = extension.getDispatcherProviders();
        ExtensionDeclarer extensionDeclarer = this.getExtensionDeclarer(context);
        this.declareSubtypes(extensionDeclarer, customTransportProviders);
        Set<ErrorModel> soapErrors = this.getSoapErrors(extensionDeclarer);
        soapErrors.forEach(arg_0 -> ((ExtensionDeclarer)extensionDeclarer).withErrorModel(arg_0));
        ConfigurationDeclarer configDeclarer = this.getConfigDeclarer(extensionDeclarer, extension, soapErrors);
        extension.getSoapServiceProviders().forEach(provider -> this.serviceProviderDeclarer.declare(configDeclarer, (SoapServiceProviderWrapper)((Object)provider), !customTransportProviders.isEmpty()));
        return extensionDeclarer;
    }

    private void declareSubtypes(ExtensionDeclarer extension, List<MessageDispatcherProviderTypeWrapper> transportProviders) {
        if (!transportProviders.isEmpty()) {
            List types = transportProviders.stream().map(tp -> this.typeLoader.load((Type)tp.getDeclaringClass())).collect(Collectors.toList());
            extension.withSubTypes(this.typeLoader.load(MessageDispatcherProvider.class), types);
        }
    }

    private ExtensionDeclarer getExtensionDeclarer(ExtensionLoadingContext context) {
        Extension extension = MuleExtensionAnnotationParser.getExtension(this.extensionType);
        return context.getExtensionDeclarer().named(extension.name()).onVersion(this.version).fromVendor(extension.vendor()).withCategory(extension.category()).withModelProperty((ModelProperty)new SoapExtensionModelProperty()).withModelProperty((ModelProperty)new ImplementingTypeModelProperty(this.extensionType));
    }

    private ConfigurationDeclarer getConfigDeclarer(ExtensionDeclarer declarer, SoapExtensionTypeWrapper<?> extension, Set<ErrorModel> soapErrors) {
        Class clazz = extension.getDeclaringClass();
        TypeAwareConfigurationFactory configurationFactory = new TypeAwareConfigurationFactory(clazz, clazz.getClassLoader());
        ConfigurationDeclarer configDeclarer = declarer.withConfig("config").describedAs("Default configuration").withModelProperty((ModelProperty)new ConfigurationFactoryModelProperty((ConfigurationFactory)configurationFactory)).withModelProperty((ModelProperty)new ImplementingTypeModelProperty(clazz));
        this.operationDeclarer.declare(configDeclarer, this.typeLoader, soapErrors);
        return configDeclarer;
    }

    private Set<ErrorModel> getSoapErrors(ExtensionDeclarer declarer) {
        ErrorsModelFactory factory = new ErrorsModelFactory((ErrorTypeDefinition[])SoapErrors.class.getEnumConstants(), ((ExtensionDeclaration)declarer.getDeclaration()).getName());
        return factory.getErrorModels();
    }
}

