/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.Optional;
import java.util.stream.Stream;
import org.mule.metadata.api.TypeLoader;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.config.internal.dsl.utils.DslConstants;
import org.mule.runtime.extension.internal.ExtensionDevelopmentFramework;
import org.mule.runtime.module.extension.internal.loader.java.property.LicenseModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.XmlDslConfiguration;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.ResolvedMinMuleVersion;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkExtensionModelParser;

public class MuleSdkApplicationExtensionModelParser
extends MuleSdkExtensionModelParser {
    public static final String APP_LOCAL_EXTENSION_NAMESPACE = "THIS";
    private static final String MIN_MULE_VERSION = "4.5";
    private final String extensionName;

    public MuleSdkApplicationExtensionModelParser(String extensionName, ArtifactAst ast, TypeLoader typeLoader, ExtensionModelHelper extensionModelHelper) {
        super(typeLoader, extensionModelHelper);
        this.extensionName = extensionName;
        this.init(ast);
    }

    public String getName() {
        return this.extensionName;
    }

    public Category getCategory() {
        return Category.COMMUNITY;
    }

    public String getVendor() {
        return "Mulesoft";
    }

    public Optional<XmlDslConfiguration> getXmlDslConfiguration() {
        return Optional.of(new XmlDslConfiguration("this", DslConstants.THIS_NAMESPACE));
    }

    public String getNamespace() {
        return APP_LOCAL_EXTENSION_NAMESPACE;
    }

    public Optional<ResolvedMinMuleVersion> getResolvedMinMuleVersion() {
        return Optional.of(new ResolvedMinMuleVersion(this.extensionName, new MuleVersion(MIN_MULE_VERSION), String.format("Application %s has min mule version %s because the Mule Sdk was introduced in that version.", this.extensionName, MIN_MULE_VERSION)));
    }

    public LicenseModelProperty getLicenseModelProperty() {
        return new LicenseModelProperty(false, true, Optional.empty());
    }

    public ExtensionDevelopmentFramework getDevelopmentFramework() {
        return ExtensionDevelopmentFramework.MULE_DSL;
    }

    @Override
    protected Stream<ComponentAst> getTopLevelElements(ArtifactAst ast) {
        return ast.topLevelComponentsStream();
    }
}

