/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.notification.HasNotifications;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.module.extension.mule.internal.loader.parser.utils.MuleSdkOperationodelParserUtils;

public class Characteristic<T> {
    private static final String CHARACTERISTICS_NOT_COMPUTED_MSG = "Characteristics have not been computed yet.";
    private final BiFunction<ComponentAstWithHierarchy, ? super T, ? extends T> mapper;
    private final T defaultValue;
    private final T stopValue;
    private T value;

    protected Characteristic(BiFunction<ComponentAstWithHierarchy, ? super T, ? extends T> mapper, T defaultValue, T stopValue) {
        this.mapper = mapper;
        this.defaultValue = defaultValue;
        this.stopValue = stopValue;
    }

    public void computeFrom(ComponentAstWithHierarchy operationAst) {
        this.value = this.mapper.apply(operationAst, (ComponentAstWithHierarchy)this.value);
    }

    public void setWithDefault() {
        this.value = this.defaultValue;
    }

    public boolean hasDefinitiveValue() {
        if (this.stopValue == null) {
            return false;
        }
        return this.stopValue.equals(this.value);
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public T getValue() {
        Preconditions.checkState((boolean)this.hasValue(), (String)CHARACTERISTICS_NOT_COMPUTED_MSG);
        return this.value;
    }

    public static class IsTransactionalCharacteristic
    extends AnyMatchFilteringCharacteristic {
        public IsTransactionalCharacteristic() {
            super(IsTransactionalCharacteristic::isTransactional, MuleSdkOperationodelParserUtils::isSkippedScopeForTx, MuleSdkOperationodelParserUtils::isIgnoredComponentForTx);
        }

        private static boolean isTransactional(ComponentAstWithHierarchy operationAst) {
            return operationAst.getComponentAst().getModel(OperationModel.class).map(ConnectableComponentModel::isTransactional).orElse(false);
        }
    }

    public static class IsBlockingCharacteristic
    extends AnyMatchCharacteristic {
        public IsBlockingCharacteristic() {
            super(IsBlockingCharacteristic::isBlocking);
        }

        public static boolean isBlocking(ComponentAstWithHierarchy operationAst) {
            return operationAst.getComponentAst().getModel(OperationModel.class).map(OperationModel::isBlocking).orElse(false);
        }
    }

    public static class AnyMatchFilteringCharacteristic
    extends BooleanFilteringCharacteristic {
        public AnyMatchFilteringCharacteristic(Predicate<ComponentAstWithHierarchy> predicate, Predicate<ComponentAstWithHierarchy> filterExpression, Predicate<ComponentAstWithHierarchy> ignoreExpression) {
            super(predicate, false, true, filterExpression, ignoreExpression);
        }
    }

    public static class BooleanFilteringCharacteristic
    extends FilteringCharacteristic<Boolean> {
        private BooleanFilteringCharacteristic(Predicate<ComponentAstWithHierarchy> predicate, Boolean defaultValue, Boolean stopValue, Predicate<ComponentAstWithHierarchy> filter, Predicate<ComponentAstWithHierarchy> ignore) {
            super((T operationAst, U curValue) -> curValue != null && Objects.equals(curValue, stopValue) ? curValue.booleanValue() : predicate.test((ComponentAstWithHierarchy)operationAst), defaultValue, stopValue, filter, ignore);
        }
    }

    public static class FilteringCharacteristic<T>
    extends Characteristic<T> {
        private final Predicate<? super ComponentAstWithHierarchy> filterExpression;
        private final Predicate<? super ComponentAstWithHierarchy> ignoreExpression;

        private FilteringCharacteristic(BiFunction<ComponentAstWithHierarchy, T, T> mapper, T defaultValue, T stopValue, Predicate<? super ComponentAstWithHierarchy> filter, Predicate<? super ComponentAstWithHierarchy> ignore) {
            super(mapper, defaultValue, stopValue);
            this.filterExpression = filter;
            this.ignoreExpression = ignore;
        }

        public boolean filterComponent(ComponentAstWithHierarchy componentAst) {
            return this.filterExpression.test(componentAst);
        }

        public boolean ignoreComponent(ComponentAstWithHierarchy componentAst) {
            return this.ignoreExpression.test(componentAst);
        }
    }

    public static class AggregatedNotificationsCharacteristic
    extends Characteristic<List<NotificationModel>> {
        public AggregatedNotificationsCharacteristic() {
            super(AggregatedNotificationsCharacteristic::aggregator, Collections.emptyList(), null);
        }

        private static List<NotificationModel> aggregator(ComponentAstWithHierarchy operationAst, List<NotificationModel> notificationModels) {
            Optional operationModel = operationAst.getComponentAst().getModel(OperationModel.class);
            if (notificationModels == null) {
                notificationModels = new ArrayList<NotificationModel>();
            }
            notificationModels.addAll(operationModel.map(HasNotifications::getNotificationModels).orElse(Collections.emptySet()));
            return notificationModels;
        }
    }

    public static class AnyMatchCharacteristic
    extends BooleanCharacteristic {
        public AnyMatchCharacteristic(Predicate<ComponentAstWithHierarchy> predicate) {
            super(predicate, false, true);
        }
    }

    public static class BooleanCharacteristic
    extends Characteristic<Boolean> {
        private BooleanCharacteristic(Predicate<ComponentAstWithHierarchy> predicate, Boolean defaultValue, Boolean stopValue) {
            super((ComponentAstWithHierarchy operationAst, ? super T curValue) -> curValue != null && Objects.equals(curValue, stopValue) ? curValue.booleanValue() : predicate.test((ComponentAstWithHierarchy)operationAst), defaultValue, stopValue);
        }
    }

    public static class ComponentAstWithHierarchy {
        private final ComponentAst componentAst;
        private final List<ComponentAst> hierarchy;

        public ComponentAstWithHierarchy(Pair<ComponentAst, List<ComponentAst>> pair) {
            this((ComponentAst)pair.getFirst(), (List)pair.getSecond());
        }

        public ComponentAstWithHierarchy(ComponentAst componentAst, List<ComponentAst> hierarchy) {
            this.componentAst = componentAst;
            this.hierarchy = hierarchy;
        }

        public ComponentAst getComponentAst() {
            return this.componentAst;
        }

        public List<ComponentAst> getHierarchy() {
            return this.hierarchy;
        }

        public String toString() {
            return "ComponentAstWithHierarchy{componentAst=" + this.componentAst + ", hierarchy=" + this.hierarchy + '}';
        }
    }
}

