/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.mule.metadata.api.TypeLoader;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.DefaultOutputModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ErrorModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.NestedChainModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.NestedRouteModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OutputModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.StereotypeModelFactory;
import org.mule.runtime.module.extension.mule.internal.execution.MuleOperationExecutor;
import org.mule.runtime.module.extension.mule.internal.loader.parser.BaseMuleSdkExtensionModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkParameterGroupModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.VoidOutputModelParser;

class MuleSdkOperationModelParserSdk
extends BaseMuleSdkExtensionModelParser
implements OperationModelParser {
    private static final String BODY_CHILD = "body";
    private static final String DESCRIPTION_PARAMETER = "description";
    private static final String DISPLAY_PARAMETER = "displayName";
    private static final String NAME_PARAMETER = "name";
    private static final String SUMMARY_PARAMETER = "summary";
    private static final String TYPE_PARAMETER = "type";
    private static final String VISIBILITY_PARAMETER = "visibility";
    private static final String DEPRECATED_CONSTRUCT_NAME = "deprecated";
    private static final String CHARACTERISTICS_NOT_COMPUTED_MSG = "Characteristics have not been computed yet.";
    private final ComponentAst operation;
    private final TypeLoader typeLoader;
    private final Characteristic<Boolean> isBlocking = new AnyMatchCharacteristic(OperationModel::isBlocking);
    private final Characteristic<List<NotificationModel>> notificationModels = new AggregatedNotificationsCharacteristic();
    private String name;

    public MuleSdkOperationModelParserSdk(ComponentAst operation, TypeLoader typeLoader) {
        this.operation = operation;
        this.typeLoader = typeLoader;
        this.parseStructure();
    }

    private void parseStructure() {
        this.name = (String)this.getParameter(this.operation, NAME_PARAMETER);
    }

    private OutputModelParser asOutputModelParser(ComponentAst outputTypeElement) {
        String type = (String)this.getParameter(outputTypeElement, TYPE_PARAMETER);
        return (OutputModelParser)this.typeLoader.load(type).map(mt -> new DefaultOutputModelParser(mt, false)).orElseThrow(() -> new IllegalModelDefinitionException(String.format("Component <%s:%s> defines %s as '%s' but such type is not defined in the application", outputTypeElement.getIdentifier().getNamespace(), outputTypeElement.getIdentifier().getName(), outputTypeElement.getIdentifier().getName())));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.getOptionalParameter(this.operation, DESCRIPTION_PARAMETER).orElse("");
    }

    public List<ModelProperty> getAdditionalModelProperties() {
        return Collections.emptyList();
    }

    public Stream<NotificationModel> getEmittedNotificationsStream(Function<String, Optional<NotificationModel>> notificationMapper) {
        return this.notificationModels.getValue().stream();
    }

    public OutputModelParser getOutputType() {
        return this.asOutputModelParser(this.getOutputPayloadTypeElement());
    }

    public OutputModelParser getAttributesOutputType() {
        return this.getOutputAttributesTypeElement().map(this::asOutputModelParser).orElse(VoidOutputModelParser.INSTANCE);
    }

    public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
        return this.getSingleChild(this.operation, "parameters").map(parameters -> Collections.singletonList(new MuleSdkParameterGroupModelParser((ComponentAst)parameters, this.typeLoader))).orElse(Collections.emptyList());
    }

    public ComponentVisibility getComponentVisibility() {
        return this.getOptionalParameter(this.operation, VISIBILITY_PARAMETER).map(visibility -> ComponentVisibility.valueOf((String)visibility)).orElse(ComponentVisibility.PUBLIC);
    }

    public List<NestedRouteModelParser> getNestedRouteParsers() {
        return Collections.emptyList();
    }

    public Optional<CompletableComponentExecutorModelProperty> getExecutorModelProperty() {
        return Optional.of(new CompletableComponentExecutorModelProperty((model, p) -> new MuleOperationExecutor(model)));
    }

    public Optional<NestedChainModelParser> getNestedChainParser() {
        return Optional.empty();
    }

    public boolean isBlocking() {
        return this.isBlocking.getValue();
    }

    public boolean isIgnored() {
        return false;
    }

    public boolean isScope() {
        return false;
    }

    public boolean isRouter() {
        return false;
    }

    public boolean isConnected() {
        return false;
    }

    public boolean hasConfig() {
        return false;
    }

    public boolean supportsStreaming() {
        return false;
    }

    public boolean isTransactional() {
        return false;
    }

    public boolean isAutoPaging() {
        return false;
    }

    public Optional<ExecutionType> getExecutionType() {
        return Optional.of(ExecutionType.CPU_LITE);
    }

    public Optional<MediaTypeModelProperty> getMediaTypeModelProperty() {
        return Optional.empty();
    }

    public Optional<ExceptionHandlerModelProperty> getExceptionHandlerModelProperty() {
        return Optional.empty();
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return this.getSingleChild(this.operation, DEPRECATED_CONSTRUCT_NAME).map(this::buildDeprecationModel);
    }

    public Optional<DisplayModel> getDisplayModel() {
        String summary = this.getOptionalParameter(this.operation, SUMMARY_PARAMETER).orElse(null);
        String displayName = this.getOptionalParameter(this.operation, DISPLAY_PARAMETER).orElse(null);
        if (!StringUtils.isBlank((String)displayName) || !StringUtils.isBlank((String)summary)) {
            return Optional.of(DisplayModel.builder().summary(summary).displayName(displayName).build());
        }
        return Optional.empty();
    }

    public List<ErrorModelParser> getErrorModelParsers() {
        return Collections.emptyList();
    }

    public Set<String> getSemanticTerms() {
        return Collections.emptySet();
    }

    public Optional<StereotypeModel> getStereotype(StereotypeModelFactory factory) {
        return Optional.empty();
    }

    private ComponentAst getOutputPayloadTypeElement() {
        String elementName = "payload-type";
        return this.getOutputElement("payload-type").orElseThrow(() -> new IllegalOperationModelDefinitionException(String.format("Operation '%s' is missing its <%s> declaration", this.getName(), "payload-type")));
    }

    private Optional<ComponentAst> getOutputAttributesTypeElement() {
        return this.getOutputElement("attributes-type");
    }

    private Optional<ComponentAst> getOutputElement(String elementName) {
        ComponentAst output = (ComponentAst)this.operation.directChildrenStreamByIdentifier(null, "output").findFirst().orElseThrow(() -> new IllegalOperationModelDefinitionException(String.format("Operation '%s' is missing its <output> declaration", this.getName())));
        return output.directChildrenStreamByIdentifier(null, elementName).findFirst();
    }

    private ComponentAst getBody() {
        return this.getSingleChild(this.operation, BODY_CHILD).get();
    }

    private Stream<OperationModel> expandOperationWithoutModel(Map<String, MuleSdkOperationModelParserSdk> operationModelParsersByName, Set<String> visitedOperations, ComponentAst componentAst) {
        MuleSdkOperationModelParserSdk operationParser = operationModelParsersByName.get(componentAst.getIdentifier().getName());
        if (operationParser != null) {
            return operationParser.getOperationModelsRecursiveStream(operationModelParsersByName, visitedOperations);
        }
        return Stream.empty();
    }

    private Stream<OperationModel> getOperationModelsRecursiveStream(Map<String, MuleSdkOperationModelParserSdk> operationModelParsersByName) {
        HashSet<String> visitedOperations = new HashSet<String>();
        return this.getOperationModelsRecursiveStream(operationModelParsersByName, visitedOperations);
    }

    private Stream<OperationModel> getOperationModelsRecursiveStream(Map<String, MuleSdkOperationModelParserSdk> operationModelParsersByName, Set<String> visitedOperations) {
        if (!visitedOperations.add(this.getName())) {
            return Stream.empty();
        }
        return this.getBody().recursiveStream().flatMap(componentAst -> {
            Optional operationModel = componentAst.getModel(OperationModel.class);
            if (operationModel.isPresent()) {
                return Stream.of(operationModel.get());
            }
            if (componentAst.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.UNKNOWN)) {
                return this.expandOperationWithoutModel(operationModelParsersByName, visitedOperations, (ComponentAst)componentAst);
            }
            return Stream.empty();
        });
    }

    public void computeCharacteristics(Map<String, MuleSdkOperationModelParserSdk> operationModelParsersByName) {
        this.computeCharacteristics(Arrays.asList(this.isBlocking, this.notificationModels), operationModelParsersByName);
    }

    private void computeCharacteristics(List<Characteristic<?>> characteristics, Map<String, MuleSdkOperationModelParserSdk> operationModelParsersByName) {
        this.getOperationModelsRecursiveStream(operationModelParsersByName).anyMatch(operationModel -> {
            for (Characteristic characteristic : characteristics) {
                characteristic.computeFrom((OperationModel)operationModel);
            }
            return this.areAllCharacteristicsWithDefinitiveValue(characteristics);
        });
        for (Characteristic<?> characteristic : characteristics) {
            if (characteristic.hasValue()) continue;
            characteristic.setWithDefault();
        }
    }

    private boolean areAllCharacteristicsWithDefinitiveValue(List<Characteristic<?>> characteristics) {
        return characteristics.stream().allMatch(Characteristic::hasDefinitiveValue);
    }

    private static class AggregatedNotificationsCharacteristic
    extends Characteristic<List<NotificationModel>> {
        private AggregatedNotificationsCharacteristic() {
            super(AggregatedNotificationsCharacteristic::aggregator, Collections.emptyList(), null);
        }

        private static List<NotificationModel> aggregator(OperationModel operationModel, List<NotificationModel> notificationModels) {
            if (notificationModels == null) {
                notificationModels = new ArrayList<NotificationModel>();
            }
            notificationModels.addAll(operationModel.getNotificationModels());
            return notificationModels;
        }
    }

    private static class AnyMatchCharacteristic
    extends BooleanCharacteristic {
        private AnyMatchCharacteristic(Predicate<OperationModel> predicate) {
            super(predicate, false, true);
        }
    }

    private static class BooleanCharacteristic
    extends Characteristic<Boolean> {
        private BooleanCharacteristic(Predicate<OperationModel> predicate, Boolean defaultValue, Boolean stopValue) {
            super((T operationModel, U curValue) -> curValue != null && curValue == stopValue ? curValue.booleanValue() : predicate.test((OperationModel)operationModel), defaultValue, stopValue);
        }
    }

    private static class Characteristic<T> {
        private final BiFunction<OperationModel, T, T> mapper;
        private final T defaultValue;
        private final T stopValue;
        private T value;

        private Characteristic(BiFunction<OperationModel, T, T> mapper, T defaultValue, T stopValue) {
            this.mapper = mapper;
            this.defaultValue = defaultValue;
            this.stopValue = stopValue;
        }

        public void computeFrom(OperationModel operationModel) {
            this.value = this.mapper.apply(operationModel, (OperationModel)this.value);
        }

        public void setWithDefault() {
            this.value = this.defaultValue;
        }

        public boolean hasDefinitiveValue() {
            if (this.stopValue == null) {
                return false;
            }
            return this.stopValue.equals(this.value);
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public T getValue() {
            Preconditions.checkState((boolean)this.hasValue(), (String)MuleSdkOperationModelParserSdk.CHARACTERISTICS_NOT_COMPUTED_MSG);
            return this.value;
        }
    }
}

