/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.util.IOUtils;

@NoExtend
@NoInstantiate
public final class ConfigResource {
    private static final List<String> CLASS_PATH_ENTRIES;
    private static final boolean isWindows;
    protected String resourceName;
    private URL url;
    private InputStream inputStream;

    public ConfigResource(String resourceName) throws IOException {
        this(resourceName, IOUtils.getResourceAsUrl((String)resourceName, ConfigResource.class, (boolean)true, (boolean)true));
    }

    public ConfigResource(URL url) {
        this.url = url;
        if (url.getProtocol().equals("jar")) {
            this.resourceName = url.toExternalForm().split("!/")[1];
        } else if (url.getProtocol().equals("file")) {
            String updatedUrl = isWindows && url.getPath().startsWith("/") ? url.getPath().substring(1) : url.getPath();
            this.resourceName = CLASS_PATH_ENTRIES.stream().filter(cp -> updatedUrl.startsWith((String)cp)).findAny().map(cp -> updatedUrl.substring(cp.length() + 1)).orElse(url.toExternalForm());
        } else {
            this.resourceName = url.toExternalForm();
        }
    }

    public ConfigResource(String resourceName, URL url) throws IOException {
        this.resourceName = resourceName;
        if (url == null) {
            throw new FileNotFoundException(resourceName);
        }
        this.url = url;
    }

    public ConfigResource(String resourceName, InputStream inputStream) {
        this.inputStream = inputStream;
        this.resourceName = resourceName;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.url != null) {
            return IOUtils.getInputStreamWithCacheControl((URL)this.url);
        }
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public boolean isStreamOpen() {
        return this.inputStream != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigResource that = (ConfigResource)o;
        return !(this.resourceName != null ? !this.resourceName.equals(that.resourceName) : that.resourceName != null);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.resourceName != null ? this.resourceName.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigResource");
        sb.append("{resourceName='").append(this.resourceName).append('\'');
        sb.append('}');
        return sb.toString();
    }

    static {
        isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
        String classPath = System.getProperty("java.class.path");
        String modulePath = System.getProperty("jdk.module.path");
        String pathSeparator = System.getProperty("path.separator");
        List allClassPathEntries = (modulePath != null ? Stream.concat(Stream.of(classPath.split(pathSeparator)), Stream.of(modulePath.split(pathSeparator))) : Stream.of(classPath.split(pathSeparator))).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        CLASS_PATH_ENTRIES = allClassPathEntries.stream().map(line -> line.replace("\\", "/")).collect(Collectors.toList());
    }
}

