/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.mule.runtime.module.deployment.internal.util.ElementAddedEvent;
import org.mule.runtime.module.deployment.internal.util.ElementRemovedEvent;
import org.mule.runtime.module.deployment.internal.util.ElementUpdatedEvent;
import org.mule.runtime.module.deployment.internal.util.ElementsClearedEvent;
import org.mule.runtime.module.deployment.internal.util.MultiElementAddedEvent;
import org.mule.runtime.module.deployment.internal.util.MultiElementRemovedEvent;

public class ObservableList<E>
implements List<E> {
    private List<E> delegate;
    private PropertyChangeSupport pcs;

    public ObservableList() {
        this(new ArrayList());
    }

    public ObservableList(List<E> delegate) {
        this.delegate = delegate;
        this.pcs = new PropertyChangeSupport(this);
    }

    @Override
    public synchronized void add(int index, E element) {
        this.delegate.add(index, element);
        this.pcs.firePropertyChange(new ElementAddedEvent(this, element, index));
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        int index = this.size() - 1;
        index = index < 0 ? 0 : index;
        boolean success = this.delegate.addAll(c);
        if (success && c != null) {
            ArrayList values = new ArrayList();
            for (Object element : values) {
                values.add(element);
            }
            if (values.size() > 0) {
                this.pcs.firePropertyChange(new MultiElementAddedEvent(this, index, values));
            }
        }
        return success;
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> c) {
        boolean success = this.delegate.addAll(index, c);
        if (success && c != null) {
            ArrayList<E> values = new ArrayList<E>();
            for (E element : c) {
                values.add(element);
            }
            if (values.size() > 0) {
                this.pcs.firePropertyChange(new MultiElementAddedEvent(this, index, values));
            }
        }
        return success;
    }

    @Override
    public synchronized void clear() {
        ArrayList<E> values = new ArrayList<E>();
        values.addAll(this.delegate);
        this.delegate.clear();
        if (!values.isEmpty()) {
            this.pcs.firePropertyChange(new ElementsClearedEvent(this, values));
        }
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public synchronized E get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public synchronized int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public synchronized Iterator<E> iterator() {
        return new ObservableIterator(new ArrayList<E>(this.delegate).iterator());
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public synchronized ListIterator<E> listIterator() {
        return new ObservableListIterator(new ArrayList<E>(this.delegate).listIterator(), 0);
    }

    @Override
    public synchronized ListIterator<E> listIterator(int index) {
        return new ObservableListIterator(new ArrayList<E>(this.delegate).listIterator(index), index);
    }

    @Override
    public synchronized E remove(int index) {
        E element = this.delegate.remove(index);
        this.pcs.firePropertyChange(new ElementRemovedEvent(this, element, index));
        return element;
    }

    @Override
    public synchronized boolean remove(Object o) {
        int index = this.delegate.indexOf(o);
        boolean success = this.delegate.remove(o);
        if (success) {
            this.pcs.firePropertyChange(new ElementRemovedEvent(this, o, index));
        }
        return success;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        ArrayList values = new ArrayList();
        for (Object element : c) {
            if (!this.delegate.contains(element)) continue;
            values.add(element);
        }
        boolean success = this.delegate.removeAll(c);
        if (success && !values.isEmpty()) {
            this.pcs.firePropertyChange(new MultiElementRemovedEvent(this, values));
        }
        return success;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        boolean success;
        if (c == null) {
            return false;
        }
        ArrayList<E> values = new ArrayList<E>();
        if (c != null) {
            for (E element : this.delegate) {
                if (c.contains(element)) continue;
                values.add(element);
            }
        }
        if ((success = this.delegate.retainAll(c)) && !values.isEmpty()) {
            this.pcs.firePropertyChange(new MultiElementRemovedEvent(this, values));
        }
        return success;
    }

    @Override
    public synchronized E set(int index, E element) {
        E oldValue = this.delegate.set(index, element);
        this.pcs.firePropertyChange(new ElementUpdatedEvent((Object)this, oldValue, element, index));
        return oldValue;
    }

    @Override
    public synchronized int size() {
        return this.delegate.size();
    }

    @Override
    public synchronized List<E> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    @Override
    public synchronized Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public synchronized boolean add(E o) {
        boolean success = this.delegate.add(o);
        if (success) {
            this.pcs.firePropertyChange(new ElementAddedEvent(this, o, this.size() - 1));
        }
        return success;
    }

    @Override
    public synchronized Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    protected class ObservableListIterator
    extends ObservableIterator
    implements ListIterator<E> {
        public ObservableListIterator(ListIterator<E> iterDelegate, int index) {
            super(iterDelegate);
            this.cursor = index;
        }

        public ListIterator<E> getListIterator() {
            return (ListIterator)this.getDelegate();
        }

        @Override
        public void add(E o) {
            this.getListIterator().add(o);
            ++this.cursor;
            this.lastRet = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.getListIterator().hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.getListIterator().nextIndex();
        }

        @Override
        public E previous() {
            Object prev = this.getListIterator().previous();
            this.lastRet = --this.cursor;
            return prev;
        }

        @Override
        public int previousIndex() {
            return this.getListIterator().previousIndex();
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException("No element has been returned yet, or remove() or add() is called after the return.");
            }
            ObservableList.this.set(this.lastRet, e);
        }
    }

    private class ObservableIterator
    implements Iterator<E> {
        protected static final int LAST_RET_NONE = -1;
        private Iterator<E> iterDelegate;
        protected int cursor = 0;
        protected int lastRet = -1;

        public ObservableIterator(Iterator<E> iterDelegate) {
            this.iterDelegate = iterDelegate;
        }

        public Iterator<E> getDelegate() {
            return this.iterDelegate;
        }

        @Override
        public boolean hasNext() {
            return this.iterDelegate.hasNext();
        }

        @Override
        public E next() {
            Object next = this.iterDelegate.next();
            this.lastRet = this.cursor++;
            return next;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException("No element has been returned yet, or remove() or add() is called after the return.");
            }
            this.iterDelegate.remove();
            this.cursor = this.lastRet;
            this.lastRet = -1;
        }
    }
}

