/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.application;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoader;
import org.mule.runtime.deployment.model.internal.domain.MuleSharedDomainClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@SmallTest
@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={MuleArtifactClassLoader.class})
public class MuleApplicationClassLoaderTestCase
extends AbstractMuleTestCase {
    private static final String RESOURCE_IN_CLASSES_AND_JAR = "test-resource-1.txt";
    private static final String RESOURCE_JUST_IN_JAR = "test-resource-2.txt";
    private static final String RESOURCE_JUST_IN_CLASSES = "test-resource-3.txt";
    private static final String RESOURCE_JUST_IN_DOMAIN = "test-resource-4.txt";
    private static final String DOMAIN_NAME = "test-domain";
    private static final String APP_NAME = "test-app";
    @Rule
    public TemporaryFolder tempMuleHome = new TemporaryFolder();
    private String previousMuleHome;
    private MuleSharedDomainClassLoader domainCL;
    private MuleApplicationClassLoader appCL;
    private File domainDir;
    private File appFolder;
    private File jarFile;

    @Before
    public void createAppClassLoader() throws Exception {
        this.previousMuleHome = System.setProperty("mule.home", this.tempMuleHome.getRoot().getAbsolutePath());
        LinkedList<URL> urls = new LinkedList<URL>();
        this.appFolder = MuleFoldersUtil.getAppFolder((String)APP_NAME);
        Assert.assertThat((Object)this.appFolder.mkdirs(), (Matcher)Is.is((Object)true));
        FileUtils.stringToFile((String)new File(this.appFolder, RESOURCE_IN_CLASSES_AND_JAR).getAbsolutePath(), (String)"Some text");
        FileUtils.stringToFile((String)new File(this.appFolder, RESOURCE_JUST_IN_CLASSES).getAbsolutePath(), (String)"Some text");
        urls.add(this.appFolder.toURI().toURL());
        File libDir = MuleFoldersUtil.getAppLibFolder((String)APP_NAME);
        Assert.assertThat((Object)libDir.mkdirs(), (Matcher)Is.is((Object)true));
        URL resourceSrcJarFile = Thread.currentThread().getContextClassLoader().getResource("test-jar-with-resources.jar");
        Assert.assertNotNull((Object)resourceSrcJarFile);
        File srcJarFile = new File(resourceSrcJarFile.toURI());
        this.jarFile = new File(libDir, "test-jar-with-resources.jar");
        FileUtils.copyFile((File)srcJarFile, (File)this.jarFile, (boolean)false);
        urls.add(this.jarFile.toURI().toURL());
        this.domainDir = MuleFoldersUtil.getDomainFolder((String)DOMAIN_NAME);
        Assert.assertThat((Object)this.domainDir.mkdirs(), (Matcher)Is.is((Object)true));
        FileUtils.stringToFile((String)new File(this.domainDir, RESOURCE_JUST_IN_DOMAIN).getAbsolutePath(), (String)"Some text");
        PowerMockito.mockStatic(MuleArtifactClassLoader.class, (Class[])new Class[0]);
        this.domainCL = new MuleSharedDomainClassLoader((ArtifactDescriptor)new DomainDescriptor(DOMAIN_NAME), Thread.currentThread().getContextClassLoader(), (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class), Collections.emptyList(), Collections.emptyList());
        ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(APP_NAME);
        ClassLoaderModel classLoaderModel = new ClassLoaderModel.ClassLoaderModelBuilder(applicationDescriptor.getClassLoaderModel()).containing(MuleFoldersUtil.getAppFolder((String)APP_NAME).toURI().toURL()).build();
        applicationDescriptor.setClassLoaderModel(classLoaderModel);
        this.appCL = new MuleApplicationClassLoader(APP_NAME, (ArtifactDescriptor)applicationDescriptor, (ClassLoader)this.domainCL, null, urls, (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class), Collections.emptyList());
    }

    @After
    public void cleanUp() {
        if (this.previousMuleHome != null) {
            System.setProperty("mule.home", this.previousMuleHome);
        }
        FileUtils.deleteTree((File)this.tempMuleHome.getRoot());
    }

    @Test
    public void loadLocalResourcesOnlyFromExpectedDirectories() throws Exception {
        this.assertLoadedFromClassesDir(this.appCL.findResource(RESOURCE_IN_CLASSES_AND_JAR));
        this.assertLoadedFromJarFile(this.appCL.findResource(RESOURCE_JUST_IN_JAR));
        this.assertLoadedFromClassesDir(this.appCL.findResource(RESOURCE_JUST_IN_CLASSES));
        this.assertNotLoaded(this.appCL.findResource(RESOURCE_JUST_IN_DOMAIN));
        this.assertLoadedFromDomainDir(this.domainCL.findResource(RESOURCE_JUST_IN_DOMAIN));
        this.assertLoadedFromClassesDir(this.appCL.findLocalResource(RESOURCE_IN_CLASSES_AND_JAR));
        this.assertLoadedFromClassesDir(this.appCL.findLocalResource(RESOURCE_JUST_IN_CLASSES));
        this.assertNotLoaded(this.appCL.findLocalResource(RESOURCE_JUST_IN_JAR));
        this.assertNotLoaded(this.appCL.findLocalResource(RESOURCE_JUST_IN_DOMAIN));
    }

    private void assertLoadedFromClassesDir(URL resource) throws URISyntaxException {
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"file", (Object)resource.getProtocol());
        Assert.assertTrue((boolean)resource.toURI().toString().contains(this.appFolder.toURI().toString()));
    }

    private void assertLoadedFromJarFile(URL resource) throws URISyntaxException {
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"jar", (Object)resource.getProtocol());
        Assert.assertTrue((boolean)resource.toURI().toString().contains(this.jarFile.toURI().toString()));
    }

    private void assertLoadedFromDomainDir(URL resource) throws URISyntaxException {
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"file", (Object)resource.getProtocol());
        Assert.assertTrue((boolean)resource.toURI().toString().contains(this.domainDir.toURI().toString()));
    }

    private void assertNotLoaded(URL resource) {
        Assert.assertNull((Object)resource);
    }
}

