/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.api.policy;

import java.util.Collections;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class PolicyTemplateDescriptorTestCase
extends AbstractMuleTestCase {
    private static final String POLICY_NAME = "policyName";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void verifiesPolicyTemplateDoesNotExportPackages() throws Exception {
        PolicyTemplateDescriptor policyTemplateDescriptor = new PolicyTemplateDescriptor(POLICY_NAME);
        ClassLoaderModel classLoaderModel = new ClassLoaderModel.ClassLoaderModelBuilder().exportingPackages(Collections.singleton("org.foo")).build();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("A policy template artifact cannot export packages");
        policyTemplateDescriptor.setClassLoaderModel(classLoaderModel);
    }

    @Test
    public void verifiesPolicyTemplateDoesNotExportResources() throws Exception {
        PolicyTemplateDescriptor policyTemplateDescriptor = new PolicyTemplateDescriptor(POLICY_NAME);
        ClassLoaderModel classLoaderModel = new ClassLoaderModel.ClassLoaderModelBuilder().exportingResources(Collections.singleton("META-INF/foo.xml")).build();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("A policy template artifact cannot export resources");
        policyTemplateDescriptor.setClassLoaderModel(classLoaderModel);
    }
}

