/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.application;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;

public class ApplicationClassLoaderBuilder
extends AbstractArtifactClassLoaderBuilder<ApplicationClassLoaderBuilder> {
    private final DeployableArtifactClassLoaderFactory artifactClassLoaderFactory;
    private Domain domain;

    public ApplicationClassLoaderBuilder(DeployableArtifactClassLoaderFactory<ApplicationDescriptor> artifactClassLoaderFactory, ArtifactClassLoaderFactory<ArtifactPluginDescriptor> artifactPluginClassLoaderFactory) {
        super(artifactPluginClassLoaderFactory);
        this.artifactClassLoaderFactory = artifactClassLoaderFactory;
    }

    public MuleDeployableArtifactClassLoader build() throws IOException {
        Preconditions.checkState((this.domain != null ? 1 : 0) != 0, (String)"Domain cannot be null");
        return (MuleDeployableArtifactClassLoader)super.build();
    }

    @Override
    protected ArtifactClassLoader createArtifactClassLoader(String artifactId, RegionClassLoader regionClassLoader) {
        return this.artifactClassLoaderFactory.create(artifactId, (ArtifactClassLoader)regionClassLoader, this.artifactDescriptor, this.artifactPluginClassLoaders);
    }

    @Override
    protected String getArtifactId(ArtifactDescriptor artifactDescriptor) {
        return ApplicationClassLoaderBuilder.getApplicationId(this.domain.getArtifactId(), artifactDescriptor.getName());
    }

    @Override
    protected ArtifactClassLoader getParentClassLoader() {
        return this.domain.getArtifactClassLoader();
    }

    public ApplicationClassLoaderBuilder setDomain(Domain domain) {
        this.domain = domain;
        return this;
    }

    public static String getApplicationId(String domainId, String applicationName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)domainId) ? 1 : 0) != 0, (String)"domainId cannot be empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((String)applicationName) ? 1 : 0) != 0, (String)"applicationName cannot be empty");
        return domainId + "/app/" + applicationName;
    }
}

