/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.api.extension.RuntimeExtensionModelProvider;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.plugin.LoaderDescriber;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;

public class ExtensionModelDiscoverer {
    public Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> discoverPluginsExtensionModels(ExtensionModelLoaderRepository loaderRepository, List<Pair<ArtifactPluginDescriptor, ArtifactClassLoader>> artifactPlugins) {
        return this.discoverPluginsExtensionModels(loaderRepository, artifactPlugins, new HashSet<ExtensionModel>());
    }

    public Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> discoverPluginsExtensionModels(ExtensionModelLoaderRepository loaderRepository, List<Pair<ArtifactPluginDescriptor, ArtifactClassLoader>> artifactPlugins, Set<ExtensionModel> parentArtifactExtensions) {
        HashSet<Pair<ArtifactPluginDescriptor, ExtensionModel>> descriptorsWithExtensions = new HashSet<Pair<ArtifactPluginDescriptor, ExtensionModel>>();
        artifactPlugins.forEach(artifactPlugin -> {
            Set extensions = descriptorsWithExtensions.stream().map(Pair::getSecond).collect(Collectors.toSet());
            extensions.addAll(parentArtifactExtensions);
            ArtifactPluginDescriptor artifactPluginDescriptor = (ArtifactPluginDescriptor)artifactPlugin.getFirst();
            Optional loaderDescriber = artifactPluginDescriptor.getExtensionModelDescriptorProperty();
            ClassLoader artifactClassloader = ((ArtifactClassLoader)artifactPlugin.getSecond()).getClassLoader();
            String artifactName = artifactPluginDescriptor.getName();
            ExtensionModel extension = loaderDescriber.map(describer -> this.discoverExtensionThroughJsonDescriber(loaderRepository, (LoaderDescriber)describer, extensions, artifactClassloader, artifactName)).orElse(null);
            if (extension != null) {
                descriptorsWithExtensions.add(new Pair((Object)artifactPluginDescriptor, (Object)extension));
            }
        });
        return descriptorsWithExtensions;
    }

    public Set<ExtensionModel> discoverRuntimeExtensionModels() {
        HashSet<ExtensionModel> extensionModels = new HashSet<ExtensionModel>();
        Collection runtimeExtensionModelProviders = new SpiServiceRegistry().lookupProviders(RuntimeExtensionModelProvider.class, Thread.currentThread().getContextClassLoader());
        for (RuntimeExtensionModelProvider runtimeExtensionModelProvider : runtimeExtensionModelProviders) {
            extensionModels.add(runtimeExtensionModelProvider.createExtensionModel());
        }
        return extensionModels;
    }

    private ExtensionModel discoverExtensionThroughJsonDescriber(ExtensionModelLoaderRepository extensionModelLoaderRepository, LoaderDescriber loaderDescriber, Set<ExtensionModel> extensions, ClassLoader artifactClassloader, String artifactName) {
        ExtensionModelLoader loader = (ExtensionModelLoader)extensionModelLoaderRepository.getExtensionModelLoader(loaderDescriber).orElseThrow(() -> new IllegalArgumentException(String.format("The identifier '%s' does not match with the describers available to generate an ExtensionModel (working with the plugin '%s')", loaderDescriber.getId(), artifactName)));
        ExtensionModel coreModel = MuleExtensionModelProvider.getExtensionModel();
        if (!extensions.contains(coreModel)) {
            extensions = ImmutableSet.builder().addAll(extensions).add((Object)coreModel).build();
        }
        return loader.loadExtensionModel(artifactClassloader, DslResolvingContext.getDefault(extensions), loaderDescriber.getAttributes());
    }
}

