/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.module.artifact.internal.util.JarInfo;
import org.mule.runtime.module.deployment.impl.internal.maven.ArtifactClassLoaderModelBuilder;

public class LightweightClassLoaderModelBuilder
extends ArtifactClassLoaderModelBuilder {
    private MavenClient mavenClient;
    private Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> nonProvidedDependencies;
    private Map<Pair<String, String>, Boolean> sharedLibraryAlreadyExported = new HashMap<Pair<String, String>, Boolean>();

    public LightweightClassLoaderModelBuilder(File artifactFolder, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor artifactBundleDescriptor, MavenClient mavenClient, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> nonProvidedDependencies) {
        super(artifactFolder, artifactBundleDescriptor);
        this.mavenClient = mavenClient;
        this.nonProvidedDependencies = nonProvidedDependencies;
    }

    @Override
    protected List<URI> processPluginAdditionalDependenciesURIs(org.mule.runtime.module.artifact.api.descriptor.BundleDependency bundleDependency) {
        List resolvedAdditionalDependencies = this.mavenClient.resolveArtifactDependencies(bundleDependency.getAdditionalDependencies().stream().map(additionalDependency -> LightweightClassLoaderModelBuilder.toMavenClientBundleDescriptor(additionalDependency.getDescriptor())).collect(Collectors.toList()), Optional.of(this.mavenClient.getMavenConfiguration().getLocalMavenRepositoryLocation()), Optional.empty());
        return resolvedAdditionalDependencies.stream().map(BundleDependency::getBundleUri).collect(Collectors.toList());
    }

    private static BundleDescriptor toMavenClientBundleDescriptor(org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor descriptor) {
        return new BundleDescriptor.Builder().setGroupId(descriptor.getGroupId()).setArtifactId(descriptor.getArtifactId()).setVersion(descriptor.getVersion()).setType(descriptor.getType()).setClassifier((String)descriptor.getClassifier().orElse(null)).build();
    }

    @Override
    protected void findAndExportSharedLibrary(String groupId, String artifactId) {
        Pair sharedLibraryKey = new Pair((Object)groupId, (Object)artifactId);
        if (this.sharedLibraryAlreadyExported.containsKey(sharedLibraryKey)) {
            return;
        }
        this.sharedLibraryAlreadyExported.put((Pair<String, String>)sharedLibraryKey, true);
        Optional<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> matchingLibrary = this.nonProvidedDependencies.stream().filter(bundleDependency -> bundleDependency.getDescriptor().getGroupId().equals(groupId) && bundleDependency.getDescriptor().getArtifactId().equals(artifactId)).findAny();
        org.mule.runtime.module.artifact.api.descriptor.BundleDependency bundleDependency2 = matchingLibrary.orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Dependency %s:%s could not be found within the artifact %s. It must be declared within the maven dependencies of the artifact.", groupId, artifactId, this.artifactFolder.getName()))));
        this.exportBundleDependencyAndTransitiveDependencies(bundleDependency2);
    }

    private void exportBundleDependencyAndTransitiveDependencies(org.mule.runtime.module.artifact.api.descriptor.BundleDependency bundleDependency) {
        org.mule.runtime.module.artifact.api.descriptor.BundleDependency resolvedBundleDependency = bundleDependency;
        if (bundleDependency.getBundleUri() == null) {
            resolvedBundleDependency = this.nonProvidedDependencies.stream().filter(nonProvidedDependency -> nonProvidedDependency.getDescriptor().getGroupId().equals(bundleDependency.getDescriptor().getGroupId()) && nonProvidedDependency.getDescriptor().getArtifactId().equals(bundleDependency.getDescriptor().getArtifactId())).findAny().orElse(bundleDependency);
        }
        JarInfo jarInfo = this.fileJarExplorer.explore(resolvedBundleDependency.getBundleUri());
        this.exportingPackages(jarInfo.getPackages());
        this.exportingResources(jarInfo.getResources());
        resolvedBundleDependency.getTransitiveDependencies().forEach(this::exportBundleDependencyAndTransitiveDependencies);
    }

    private void updateAdditionalDependencyOrFail(List<BundleDependency> additionalDependencies, BundleDependency bundleDependency) {
        Reference replace = new Reference();
        additionalDependencies.stream().filter(additionalBundleDependency -> StringUtils.equals((CharSequence)additionalBundleDependency.getDescriptor().getGroupId(), (CharSequence)bundleDependency.getDescriptor().getGroupId()) && StringUtils.equals((CharSequence)additionalBundleDependency.getDescriptor().getArtifactId(), (CharSequence)bundleDependency.getDescriptor().getArtifactId())).findFirst().map(additionalBundleDependency -> {
            String additionalBundleDependencyVersion = additionalBundleDependency.getDescriptor().getVersion();
            String bundleDependencyVersion = bundleDependency.getDescriptor().getVersion();
            if (this.areSameMajor(bundleDependencyVersion, additionalBundleDependencyVersion)) {
                if (this.isNewerVersion(bundleDependencyVersion, additionalBundleDependencyVersion)) {
                    replace.set(additionalBundleDependency);
                }
            } else {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Attempting to add different major versions of the same dependency as additional plugin dependency. If this is not explicitly defined, check transitive dependencies." + System.lineSeparator() + "These are: " + System.lineSeparator() + additionalBundleDependency.toString() + System.lineSeparator() + bundleDependency.toString())));
            }
            return true;
        }).orElseGet(() -> additionalDependencies.add(bundleDependency));
        if (replace.get() != null) {
            additionalDependencies.remove(replace.get());
            additionalDependencies.add(bundleDependency);
        }
    }

    private boolean isNewerVersion(String dependencyA, String dependencyB) {
        try {
            return new Semver(dependencyA, Semver.SemverType.LOOSE).isGreaterThan(new Semver(dependencyB, Semver.SemverType.LOOSE));
        }
        catch (IllegalArgumentException e) {
            return dependencyA.compareTo(dependencyB) > 0;
        }
    }

    private boolean areSameMajor(String dependencyA, String dependencyB) {
        try {
            return new Semver(dependencyA, Semver.SemverType.LOOSE).getMajor().equals(new Semver(dependencyB, Semver.SemverType.LOOSE).getMajor());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    protected Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>> doProcessAdditionalPluginLibraries(Plugin packagingPlugin) {
        Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>> deployableArtifactAdditionalLibrariesMap = super.doProcessAdditionalPluginLibraries(packagingPlugin);
        HashMap<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>> effectivePluginsAdditionalLibrariesMap = new HashMap<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>>(deployableArtifactAdditionalLibrariesMap);
        this.nonProvidedDependencies.stream().filter(bundleDependency -> "mule-plugin".equals(bundleDependency.getDescriptor().getClassifier().orElse(null))).forEach(bundleDependency -> {
            Model effectiveModel;
            try {
                effectiveModel = this.mavenClient.getEffectiveModel(FileUtils.toFile((URL)bundleDependency.getBundleUri().toURL()), Optional.empty());
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            Optional<Plugin> artifactPackagerPlugin = this.findArtifactPackagerPlugin(effectiveModel);
            artifactPackagerPlugin.ifPresent(plugin -> {
                Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>> pluginAdditionalLibrariesMap = super.doProcessAdditionalPluginLibraries((Plugin)artifactPackagerPlugin.get());
                pluginAdditionalLibrariesMap.forEach((pluginDescriptor, additionalLibraries) -> {
                    HashSet effectivePluginAdditionalLibraries = new HashSet();
                    if (deployableArtifactAdditionalLibrariesMap.containsKey(pluginDescriptor)) {
                        effectivePluginAdditionalLibraries.addAll(additionalLibraries.stream().filter(additionalLibrary -> {
                            boolean additionalLibraryDefinedAtDeployableArtifact = this.existsInLibrariesMap(deployableArtifactAdditionalLibrariesMap, (org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)pluginDescriptor, (org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)additionalLibrary);
                            if (!additionalLibraryDefinedAtDeployableArtifact) {
                                Optional<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor> additionalLibraryDefinedByAnotherPlugin = this.findLibraryInAdditionalLibrariesMap(effectivePluginsAdditionalLibrariesMap, (org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)pluginDescriptor, (org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)additionalLibrary);
                                try {
                                    return !additionalLibraryDefinedByAnotherPlugin.isPresent() || new MuleVersion(additionalLibrary.getVersion()).newerThan(additionalLibraryDefinedByAnotherPlugin.get().getVersion());
                                }
                                catch (IllegalStateException e) {
                                    return additionalLibrary.getVersion().compareTo(additionalLibraryDefinedByAnotherPlugin.get().getVersion()) > 0;
                                }
                            }
                            return false;
                        }).collect(Collectors.toSet()));
                    } else {
                        effectivePluginAdditionalLibraries.addAll(additionalLibraries);
                    }
                    effectivePluginsAdditionalLibrariesMap.put((org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)pluginDescriptor, (Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>)additionalLibraries);
                });
            });
        });
        return effectivePluginsAdditionalLibrariesMap;
    }

    private boolean existsInLibrariesMap(Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>> additionalLibrariesPerPluginMap, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor plugin, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor additionalLibrary) {
        Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor> additionalLibraries = additionalLibrariesPerPluginMap.get(plugin);
        if (additionalLibraries == null) {
            return false;
        }
        return additionalLibraries.contains(additionalLibrary);
    }

    private Optional<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor> findLibraryInAdditionalLibrariesMap(Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>> additionalLibrariesPerPluginMap, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor plugin, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor additionalLibrary) {
        Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor> additionalLibraries = additionalLibrariesPerPluginMap.get(plugin);
        if (additionalLibraries == null) {
            return Optional.empty();
        }
        return additionalLibraries.stream().filter(bundleDescriptor -> bundleDescriptor.equals((Object)additionalLibrary)).findAny();
    }
}

