/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactoryUtils;
import org.mule.runtime.module.license.api.LicenseValidator;

public abstract class AbstractDeployableArtifactFactory<T extends DeployableArtifact>
implements ArtifactFactory<T> {
    private LicenseValidator licenseValidator;
    private ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitionProvider;

    public AbstractDeployableArtifactFactory(LicenseValidator licenseValidator, ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitionProvider) {
        this.licenseValidator = licenseValidator;
        this.runtimeComponentBuildingDefinitionProvider = runtimeComponentBuildingDefinitionProvider;
    }

    @Override
    public T createArtifact(File artifactDir, Optional<Properties> properties) throws IOException {
        T artifact = this.doCreateArtifact(artifactDir, properties);
        ArtifactFactoryUtils.validateArtifactLicense(artifact.getArtifactClassLoader().getClassLoader(), artifact.getArtifactPlugins(), this.licenseValidator);
        return artifact;
    }

    protected abstract T doCreateArtifact(File var1, Optional<Properties> var2) throws IOException;

    public abstract DeployableArtifactDescriptor createArtifactDescriptor(File var1, Optional<Properties> var2);

    public ComponentBuildingDefinitionProvider getRuntimeComponentBuildingDefinitionProvider() {
        return this.runtimeComponentBuildingDefinitionProvider;
    }
}

