/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.module.deployment.impl.internal.maven.ArtifactClassLoaderModelBuilder;

public class LightweightClassLoaderModelBuilder
extends ArtifactClassLoaderModelBuilder {
    private MavenClient mavenClient;
    private Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> nonProvidedDependencies;
    private File temporaryFolder;

    public LightweightClassLoaderModelBuilder(File artifactFolder, MavenClient mavenClient, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> nonProvidedDependencies, File temporaryFolder) {
        super(artifactFolder);
        this.mavenClient = mavenClient;
        this.nonProvidedDependencies = nonProvidedDependencies;
        this.temporaryFolder = temporaryFolder;
    }

    @Override
    protected List<URI> processPluginAdditionalDependenciesURIs(org.mule.runtime.module.artifact.api.descriptor.BundleDependency bundleDependency) {
        return this.resolveDependencies(bundleDependency.getAdditionalDependencies()).stream().map(BundleDependency::getBundleUri).collect(Collectors.toList());
    }

    private List<BundleDependency> resolveDependencies(Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> additionalDependencies) {
        ArrayList<BundleDependency> resolvedAdditionalDependencies = new ArrayList<BundleDependency>();
        additionalDependencies.stream().map(org.mule.runtime.module.artifact.api.descriptor.BundleDependency::getDescriptor).map(descriptor -> new BundleDescriptor.Builder().setGroupId(descriptor.getGroupId()).setArtifactId(descriptor.getArtifactId()).setVersion(descriptor.getVersion()).setType(descriptor.getType()).setClassifier((String)descriptor.getClassifier().orElse(null)).build()).forEach(bundleDescriptor -> this.resolveDependency((BundleDescriptor)bundleDescriptor).forEach(additionalDep -> this.updateAdditionalDependencyOrFail(resolvedAdditionalDependencies, (BundleDependency)additionalDep)));
        return resolvedAdditionalDependencies;
    }

    private List<BundleDependency> resolveDependency(BundleDescriptor dependencyBundleDescriptor) {
        ArrayList<BundleDependency> resolvedDependencies = new ArrayList<BundleDependency>();
        resolvedDependencies.add(this.mavenClient.resolveBundleDescriptor(dependencyBundleDescriptor));
        resolvedDependencies.addAll(this.mavenClient.resolveBundleDescriptorDependencies(false, false, dependencyBundleDescriptor));
        return resolvedDependencies;
    }

    private void updateAdditionalDependencyOrFail(List<BundleDependency> additionalDependencies, BundleDependency bundleDependency) {
        Reference replace = new Reference();
        additionalDependencies.stream().filter(additionalBundleDependency -> StringUtils.equals((CharSequence)additionalBundleDependency.getDescriptor().getGroupId(), (CharSequence)bundleDependency.getDescriptor().getGroupId()) && StringUtils.equals((CharSequence)additionalBundleDependency.getDescriptor().getArtifactId(), (CharSequence)bundleDependency.getDescriptor().getArtifactId())).findFirst().map(additionalBundleDependency -> {
            String additionalBundleDependencyVersion = additionalBundleDependency.getDescriptor().getVersion();
            String bundleDependencyVersion = bundleDependency.getDescriptor().getVersion();
            if (this.areSameMajor(bundleDependencyVersion, additionalBundleDependencyVersion)) {
                if (this.isNewerVersion(bundleDependencyVersion, additionalBundleDependencyVersion)) {
                    replace.set(additionalBundleDependency);
                }
            } else {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Attempting to add different major versions of the same dependency as additional plugin dependency. If this is not explicitly defined, check transitive dependencies." + System.lineSeparator() + "These are: " + System.lineSeparator() + additionalBundleDependency.toString() + System.lineSeparator() + bundleDependency.toString())));
            }
            return true;
        }).orElseGet(() -> additionalDependencies.add(bundleDependency));
        if (replace.get() != null) {
            additionalDependencies.remove(replace.get());
            additionalDependencies.add(bundleDependency);
        }
    }

    private boolean isNewerVersion(String dependencyA, String dependencyB) {
        try {
            return new Semver(dependencyA, Semver.SemverType.LOOSE).isGreaterThan(new Semver(dependencyB, Semver.SemverType.LOOSE));
        }
        catch (IllegalArgumentException e) {
            return dependencyA.compareTo(dependencyB) > 0;
        }
    }

    private boolean areSameMajor(String dependencyA, String dependencyB) {
        try {
            return new Semver(dependencyA, Semver.SemverType.LOOSE).getMajor().equals(new Semver(dependencyB, Semver.SemverType.LOOSE).getMajor());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    protected Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>> doProcessAdditionalPluginLibraries(Plugin packagingPlugin) {
        File temporaryPomFolder = new File(this.temporaryFolder, "temporary-poms");
        if (!temporaryPomFolder.exists() && !temporaryPomFolder.mkdirs()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create temporary folder under " + temporaryPomFolder.getAbsolutePath())));
        }
        Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>> deployableArtifactAdditionalLibrariesMap = super.doProcessAdditionalPluginLibraries(packagingPlugin);
        HashMap<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>> effectivePluginsAdditionalLibrariesMap = new HashMap<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>>(deployableArtifactAdditionalLibrariesMap);
        this.nonProvidedDependencies.stream().filter(bundleDependency -> "mule-plugin".equals(bundleDependency.getDescriptor().getClassifier().orElse(null))).forEach(bundleDependency -> {
            Model effectiveModel;
            try {
                effectiveModel = this.mavenClient.getEffectiveModel(FileUtils.toFile((URL)bundleDependency.getBundleUri().toURL()), Optional.of(temporaryPomFolder));
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            Optional<Plugin> artifactPackagerPlugin = this.findArtifactPackagerPlugin(effectiveModel);
            artifactPackagerPlugin.ifPresent(plugin -> {
                Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>> pluginAdditionalLibrariesMap = super.doProcessAdditionalPluginLibraries((Plugin)artifactPackagerPlugin.get());
                pluginAdditionalLibrariesMap.forEach((pluginDescriptor, additionalLibraries) -> {
                    HashSet effectivePluginAdditionalLibraries = new HashSet();
                    if (deployableArtifactAdditionalLibrariesMap.containsKey(pluginDescriptor)) {
                        effectivePluginAdditionalLibraries.addAll(additionalLibraries.stream().filter(additionalLibrary -> {
                            boolean additionalLibraryDefinedAtDeployableArtifact = this.existsInLibrariesMap(deployableArtifactAdditionalLibrariesMap, (org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)pluginDescriptor, (org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)additionalLibrary);
                            if (!additionalLibraryDefinedAtDeployableArtifact) {
                                Optional<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor> additionalLibraryDefinedByAnotherPlugin = this.findLibraryInAdditionalLibrariesMap(effectivePluginsAdditionalLibrariesMap, (org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)pluginDescriptor, (org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)additionalLibrary);
                                try {
                                    return !additionalLibraryDefinedByAnotherPlugin.isPresent() || new MuleVersion(additionalLibrary.getVersion()).newerThan(additionalLibraryDefinedByAnotherPlugin.get().getVersion());
                                }
                                catch (IllegalStateException e) {
                                    return additionalLibrary.getVersion().compareTo(additionalLibraryDefinedByAnotherPlugin.get().getVersion()) > 0;
                                }
                            }
                            return false;
                        }).collect(Collectors.toSet()));
                    } else {
                        effectivePluginAdditionalLibraries.addAll(additionalLibraries);
                    }
                    effectivePluginsAdditionalLibrariesMap.put((org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor)pluginDescriptor, (Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>)additionalLibraries);
                });
            });
        });
        return effectivePluginsAdditionalLibrariesMap;
    }

    private boolean existsInLibrariesMap(Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>> additionalLibrariesPerPluginMap, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor plugin, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor additionalLibrary) {
        Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor> additionalLibraries = additionalLibrariesPerPluginMap.get(plugin);
        if (additionalLibraries == null) {
            return false;
        }
        return additionalLibraries.contains(additionalLibrary);
    }

    private Optional<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor> findLibraryInAdditionalLibrariesMap(Map<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor>> additionalLibrariesPerPluginMap, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor plugin, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor additionalLibrary) {
        Set<org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor> additionalLibraries = additionalLibrariesPerPluginMap.get(plugin);
        if (additionalLibraries == null) {
            return Optional.empty();
        }
        return additionalLibraries.stream().filter(bundleDescriptor -> bundleDescriptor.equals((Object)additionalLibrary)).findAny();
    }
}

