/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.deployment.impl.internal.artifact.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.artifact.LoaderNotFoundException;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;

public abstract class AbstractDeployableDescriptorFactory<M extends MuleDeployableModel, T extends DeployableArtifactDescriptor>
implements ArtifactDescriptorFactory<T> {
    protected static final String MULE_CONFIG_FILES_FOLDER = "mule";
    protected final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;
    protected final DescriptorLoaderRepository descriptorLoaderRepository;

    public AbstractDeployableDescriptorFactory(ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader, DescriptorLoaderRepository descriptorLoaderRepository) {
        Preconditions.checkArgument((artifactPluginDescriptorLoader != null ? 1 : 0) != 0, (String)"ApplicationPluginDescriptorFactory cannot be null");
        this.artifactPluginDescriptorLoader = artifactPluginDescriptorLoader;
        this.descriptorLoaderRepository = descriptorLoaderRepository;
    }

    public T create(File artifactFolder) throws ArtifactDescriptorCreateException {
        File artifactJsonFile = new File(artifactFolder, ArtifactPluginDescriptor.MULE_ARTIFACT_FOLDER + File.separator + this.getDescriptorFileName());
        if (!artifactJsonFile.exists()) {
            throw new IllegalStateException("Artifact descriptor does not exists: " + artifactJsonFile);
        }
        T artifactDescriptor = this.loadFromJsonDescriptor(artifactFolder, artifactJsonFile);
        return artifactDescriptor;
    }

    protected abstract String getDescriptorFileName();

    protected T loadFromJsonDescriptor(File artifactFolder, File artifactJsonDescriptor) {
        M artifactModel = this.getArtifactJsonDescriber(artifactJsonDescriptor);
        T descriptor = this.createArtifactDescriptor(artifactFolder.getName());
        descriptor.setArtifactLocation(artifactFolder);
        descriptor.setRootFolder(artifactFolder);
        descriptor.setBundleDescriptor(this.getBundleDescriptor(artifactFolder, artifactModel));
        descriptor.setMinMuleVersion(new MuleVersion(artifactModel.getMinMuleVersion()));
        descriptor.setRedeploymentEnabled(artifactModel.isRedeploymentEnabled());
        this.doDescriptorConfig(artifactModel, descriptor);
        List configs = artifactModel.getConfigs();
        if (configs != null && !configs.isEmpty()) {
            descriptor.setConfigResources(configs.stream().map(configFile -> this.appendMuleFolder((String)configFile)).collect(Collectors.toList()));
            List<File> configFiles = descriptor.getConfigResources().stream().map(config -> new File(artifactFolder, (String)config)).collect(Collectors.toList());
            descriptor.setConfigResourcesFile(configFiles.toArray(new File[configFiles.size()]));
            descriptor.setAbsoluteResourcePaths(configFiles.stream().map(configFile -> configFile.getAbsolutePath()).collect(Collectors.toList()).toArray(new String[configFiles.size()]));
        } else {
            File configFile2 = new File(artifactFolder, this.appendMuleFolder(this.getDefaultConfigurationResource()));
            descriptor.setConfigResourcesFile(new File[]{configFile2});
            descriptor.setConfigResources((List)ImmutableList.builder().add((Object)this.getDefaultConfigurationResourceLocation()).build());
            descriptor.setAbsoluteResourcePaths(new String[]{configFile2.getAbsolutePath()});
        }
        artifactModel.getClassLoaderModelLoaderDescriptor().ifPresent(classLoaderModelLoaderDescriptor -> {
            ClassLoaderModel classLoaderModel = this.getClassLoaderModel(artifactFolder, (MuleArtifactLoaderDescriptor)classLoaderModelLoaderDescriptor);
            descriptor.setClassLoaderModel(classLoaderModel);
            try {
                descriptor.setPlugins(this.createArtifactPluginDescriptors(classLoaderModel));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
        return descriptor;
    }

    protected abstract void doDescriptorConfig(M var1, T var2);

    protected abstract T createArtifactDescriptor(String var1);

    protected abstract String getDefaultConfigurationResourceLocation();

    protected abstract String getDefaultConfigurationResource();

    protected static String invalidClassLoaderModelIdError(File pluginFolder, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor) {
        return String.format("The identifier '%s' for a class loader model descriptor is not supported (error found while reading plugin '%s')", classLoaderModelLoaderDescriptor.getId(), pluginFolder.getAbsolutePath());
    }

    protected static String invalidBundleDescriptorLoaderIdError(File pluginFolder, MuleArtifactLoaderDescriptor bundleDescriptorLoader) {
        return String.format("The identifier '%s' for a bundle descriptor loader is not supported (error found while reading plugin '%s')", bundleDescriptorLoader.getId(), pluginFolder.getAbsolutePath());
    }

    protected BundleDescriptor getBundleDescriptor(File appFolder, M muleDomainModel) {
        BundleDescriptorLoader bundleDescriptorLoader;
        try {
            bundleDescriptorLoader = this.descriptorLoaderRepository.get(muleDomainModel.getBundleDescriptorLoader().getId(), ArtifactType.APP, BundleDescriptorLoader.class);
        }
        catch (LoaderNotFoundException e) {
            throw new ArtifactDescriptorCreateException(AbstractDeployableDescriptorFactory.invalidBundleDescriptorLoaderIdError(appFolder, muleDomainModel.getBundleDescriptorLoader()));
        }
        try {
            return (BundleDescriptor)bundleDescriptorLoader.load(appFolder, muleDomainModel.getBundleDescriptorLoader().getAttributes(), ArtifactType.APP);
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new ArtifactDescriptorCreateException((Throwable)e);
        }
    }

    protected String appendMuleFolder(String configFile) {
        return MULE_CONFIG_FILES_FOLDER + File.separator + configFile;
    }

    protected ClassLoaderModel getClassLoaderModel(File artifactFolder, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor) {
        ClassLoaderModel classLoaderModel;
        ClassLoaderModelLoader classLoaderModelLoader;
        try {
            classLoaderModelLoader = this.descriptorLoaderRepository.get(classLoaderModelLoaderDescriptor.getId(), ArtifactType.APP, ClassLoaderModelLoader.class);
        }
        catch (LoaderNotFoundException e) {
            throw new ArtifactDescriptorCreateException(AbstractDeployableDescriptorFactory.invalidClassLoaderModelIdError(artifactFolder, classLoaderModelLoaderDescriptor));
        }
        try {
            classLoaderModel = (ClassLoaderModel)classLoaderModelLoader.load(artifactFolder, classLoaderModelLoaderDescriptor.getAttributes(), this.getArtifactType());
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new ArtifactDescriptorCreateException((Throwable)e);
        }
        return classLoaderModel;
    }

    protected abstract ArtifactType getArtifactType();

    protected Set<ArtifactPluginDescriptor> createArtifactPluginDescriptors(ClassLoaderModel classLoaderModel) throws IOException {
        HashSet<ArtifactPluginDescriptor> pluginDescriptors = new HashSet<ArtifactPluginDescriptor>();
        for (BundleDependency bundleDependency : classLoaderModel.getDependencies()) {
            if (!bundleDependency.getDescriptor().isPlugin()) continue;
            File pluginFile = new File(bundleDependency.getBundleUri());
            pluginDescriptors.add(this.artifactPluginDescriptorLoader.load(pluginFile));
        }
        return pluginDescriptors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected M getArtifactJsonDescriber(File jsonFile) {
        try (FileInputStream stream = new FileInputStream(jsonFile);){
            M m = this.deserializeArtifactModel(stream);
            return m;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not read extension describer on artifact '%s'", jsonFile.getAbsolutePath()), e);
        }
    }

    protected abstract M deserializeArtifactModel(InputStream var1) throws IOException;
}

