/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.descriptor.DescriptorLoader;
import org.mule.runtime.module.deployment.impl.internal.artifact.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.artifact.LoaderNotFoundException;

public class ServiceRegistryDescriptorLoaderRepository
implements DescriptorLoaderRepository {
    private final ServiceRegistry serviceRegistry;
    private final Class[] descriptorLoaderClasses = new Class[]{ClassLoaderModelLoader.class, BundleDescriptorLoader.class};
    private Map<Class, List<DescriptorLoader>> descriptorLoaders;

    public ServiceRegistryDescriptorLoaderRepository(ServiceRegistry serviceRegistry) {
        Preconditions.checkArgument((serviceRegistry != null ? 1 : 0) != 0, (String)"serviceRegistry cannot be null");
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public synchronized <T extends DescriptorLoader> T get(String id, ArtifactType artifactType, Class<T> loaderClass) throws LoaderNotFoundException {
        if (this.descriptorLoaders == null) {
            this.initializeDescriptorLoaders();
        }
        DescriptorLoader descriptorLoader = null;
        List<DescriptorLoader> registeredDescriptorLoaders = this.descriptorLoaders.get(loaderClass);
        if (registeredDescriptorLoaders != null) {
            for (DescriptorLoader loader : registeredDescriptorLoaders) {
                if (!loader.getId().equals(id) || !loader.supportsArtifactType(artifactType)) continue;
                descriptorLoader = loader;
            }
        }
        if (descriptorLoader == null) {
            throw new LoaderNotFoundException(ServiceRegistryDescriptorLoaderRepository.noRegisteredLoaderError(id, loaderClass));
        }
        return (T)descriptorLoader;
    }

    protected static <T extends DescriptorLoader> String noRegisteredLoaderError(String id, Class<T> loaderClass) {
        return String.format("There is no loader with ID='%s' and type '%s'", id, loaderClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDescriptorLoaders() {
        ServiceRegistryDescriptorLoaderRepository serviceRegistryDescriptorLoaderRepository = this;
        synchronized (serviceRegistryDescriptorLoaderRepository) {
            if (this.descriptorLoaders == null) {
                this.descriptorLoaders = new HashMap<Class, List<DescriptorLoader>>();
                for (Class descriptorLoaderClass : this.descriptorLoaderClasses) {
                    this.descriptorLoaders.put(descriptorLoaderClass, this.findBundleDescriptorLoaders(descriptorLoaderClass));
                }
            }
        }
    }

    private List<DescriptorLoader> findBundleDescriptorLoaders(Class<? extends DescriptorLoader> descriptorLoaderClass) {
        ArrayList<DescriptorLoader> descriptorLoaders = new ArrayList<DescriptorLoader>();
        Collection providers = this.serviceRegistry.lookupProviders(descriptorLoaderClass, this.getClass().getClassLoader());
        for (DescriptorLoader loader : providers) {
            descriptorLoaders.add(loader);
        }
        return descriptorLoaders;
    }
}

