/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal;

import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.internal.ContainerClassLoaderFactory;
import org.mule.runtime.container.internal.ContainerModuleDiscoverer;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.registry.SpiServiceRegistry;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginClassLoaderFactory;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoaderFactory;
import org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderFactory;
import org.mule.runtime.deployment.model.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.deployment.model.internal.plugin.BundlePluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.policy.PolicyTemplateClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.artifact.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.TrackingArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.TrackingDeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.application.TemporaryApplicationDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.application.TemporaryApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.application.ToolingApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.DefaultClassLoaderManager;
import org.mule.runtime.module.deployment.impl.internal.artifact.ServiceRegistryDescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainManager;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPluginRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.MuleExtensionModelLoaderManager;
import org.mule.runtime.module.deployment.impl.internal.policy.ApplicationPolicyTemplateClassLoaderBuilderFactory;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderManager;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.runtime.module.service.DefaultServiceDiscoverer;
import org.mule.runtime.module.service.FileSystemServiceProviderDiscoverer;
import org.mule.runtime.module.service.MuleServiceManager;
import org.mule.runtime.module.service.ReflectionServiceProviderResolutionHelper;
import org.mule.runtime.module.service.ReflectionServiceResolver;
import org.mule.runtime.module.service.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.ServiceDiscoverer;
import org.mule.runtime.module.service.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.ServiceProviderResolutionHelper;
import org.mule.runtime.module.service.ServiceRepository;
import org.mule.runtime.module.service.ServiceResolver;

public class MuleArtifactResourcesRegistry {
    private final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;
    private final DefaultDomainManager domainManager;
    private final DefaultDomainFactory domainFactory;
    private final DefaultApplicationFactory applicationFactory;
    private final ToolingApplicationFactory toolingApplicationFactory;
    private final TemporaryApplicationFactory temporaryApplicationFactory;
    private final DefaultArtifactPluginRepository artifactPluginRepository;
    private final DeployableArtifactClassLoaderFactory<DomainDescriptor> domainClassLoaderFactory;
    private final ArtifactClassLoader containerClassLoader;
    private final MuleServiceManager serviceManager;
    private final ExtensionModelLoaderManager extensionModelLoaderManager;
    private final ArtifactClassLoaderFactory<ArtifactPluginDescriptor> artifactPluginClassLoaderFactory;
    private final DefaultClassLoaderManager artifactClassLoaderManager;
    private final ModuleRepository moduleRepository;
    private final ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory;
    private final ApplicationDescriptorFactory applicationDescriptorFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final ServiceRegistryDescriptorLoaderRepository descriptorLoaderRepository;

    private MuleArtifactResourcesRegistry(ModuleRepository moduleRepository) {
        this.moduleRepository = moduleRepository;
        this.containerClassLoader = new ContainerClassLoaderFactory(moduleRepository).createContainerClassLoader(this.getClass().getClassLoader());
        this.artifactClassLoaderManager = new DefaultClassLoaderManager();
        this.domainManager = new DefaultDomainManager();
        this.domainClassLoaderFactory = this.trackDeployableArtifactClassLoaderFactory((DeployableArtifactClassLoaderFactory)new DomainClassLoaderFactory(this.containerClassLoader.getClassLoader()));
        this.artifactPluginClassLoaderFactory = this.trackArtifactClassLoaderFactory((ArtifactClassLoaderFactory)new ArtifactPluginClassLoaderFactory(moduleRepository));
        ArtifactPluginDescriptorFactory artifactPluginDescriptorFactory = new ArtifactPluginDescriptorFactory();
        this.artifactPluginRepository = new DefaultArtifactPluginRepository(artifactPluginDescriptorFactory);
        this.artifactPluginDescriptorLoader = new ArtifactPluginDescriptorLoader(artifactPluginDescriptorFactory);
        this.descriptorLoaderRepository = new ServiceRegistryDescriptorLoaderRepository((ServiceRegistry)new SpiServiceRegistry());
        this.applicationDescriptorFactory = new ApplicationDescriptorFactory(this.artifactPluginDescriptorLoader, this.artifactPluginRepository, this.descriptorLoaderRepository);
        DeployableArtifactClassLoaderFactory applicationClassLoaderFactory = this.trackDeployableArtifactClassLoaderFactory((DeployableArtifactClassLoaderFactory)new MuleApplicationClassLoaderFactory((NativeLibraryFinderFactory)new DefaultNativeLibraryFinderFactory()));
        this.pluginDependenciesResolver = new BundlePluginDependenciesResolver((ArtifactDescriptorFactory)artifactPluginDescriptorFactory);
        this.applicationClassLoaderBuilderFactory = new ApplicationClassLoaderBuilderFactory(applicationClassLoaderFactory, this.artifactPluginClassLoaderFactory);
        ServiceClassLoaderFactory serviceClassLoaderFactory = new ServiceClassLoaderFactory();
        this.serviceManager = new MuleServiceManager((ServiceDiscoverer)new DefaultServiceDiscoverer((ServiceProviderDiscoverer)new FileSystemServiceProviderDiscoverer(this.containerClassLoader, this.trackArtifactClassLoaderFactory((ArtifactClassLoaderFactory)serviceClassLoaderFactory)), (ServiceResolver)new ReflectionServiceResolver((ServiceProviderResolutionHelper)new ReflectionServiceProviderResolutionHelper())));
        this.extensionModelLoaderManager = new MuleExtensionModelLoaderManager(this.containerClassLoader);
        this.domainFactory = new DefaultDomainFactory(this.domainClassLoaderFactory, this.domainManager, this.containerClassLoader, this.artifactClassLoaderManager, (ServiceRepository)this.serviceManager);
        DeployableArtifactClassLoaderFactory policyClassLoaderFactory = this.trackDeployableArtifactClassLoaderFactory((DeployableArtifactClassLoaderFactory)new PolicyTemplateClassLoaderFactory());
        ApplicationPolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory = new ApplicationPolicyTemplateClassLoaderBuilderFactory(policyClassLoaderFactory, this.artifactPluginClassLoaderFactory);
        this.applicationFactory = new DefaultApplicationFactory(this.applicationClassLoaderBuilderFactory, this.applicationDescriptorFactory, this.artifactPluginRepository, this.domainManager, (ServiceRepository)this.serviceManager, (ExtensionModelLoaderRepository)this.extensionModelLoaderManager, this.artifactClassLoaderManager, policyTemplateClassLoaderBuilderFactory, this.pluginDependenciesResolver, this.artifactPluginDescriptorLoader);
        this.toolingApplicationFactory = new ToolingApplicationFactory(this.applicationClassLoaderBuilderFactory, this.applicationDescriptorFactory, this.artifactPluginRepository, this.domainManager, (ServiceRepository)this.serviceManager, (ExtensionModelLoaderRepository)this.extensionModelLoaderManager, this.artifactClassLoaderManager, policyTemplateClassLoaderBuilderFactory, this.pluginDependenciesResolver, this.artifactPluginDescriptorLoader);
        this.temporaryApplicationFactory = new TemporaryApplicationFactory(this.applicationClassLoaderBuilderFactory, new TemporaryApplicationDescriptorFactory(this.artifactPluginDescriptorLoader, this.artifactPluginRepository, this.descriptorLoaderRepository), this.artifactPluginRepository, this.domainManager, (ServiceRepository)this.serviceManager, (ExtensionModelLoaderRepository)this.extensionModelLoaderManager, this.artifactClassLoaderManager, policyTemplateClassLoaderBuilderFactory, this.pluginDependenciesResolver, this.artifactPluginDescriptorLoader);
    }

    private <T extends ArtifactDescriptor> ArtifactClassLoaderFactory<T> trackArtifactClassLoaderFactory(ArtifactClassLoaderFactory<T> artifactClassLoaderFactory) {
        return new TrackingArtifactClassLoaderFactory((ArtifactClassLoaderManager)this.artifactClassLoaderManager, artifactClassLoaderFactory);
    }

    private <T extends ArtifactDescriptor> DeployableArtifactClassLoaderFactory<T> trackDeployableArtifactClassLoaderFactory(DeployableArtifactClassLoaderFactory<T> deployableArtifactClassLoaderFactory) {
        return new TrackingDeployableArtifactClassLoaderFactory((ArtifactClassLoaderManager)this.artifactClassLoaderManager, deployableArtifactClassLoaderFactory);
    }

    public ArtifactPluginDescriptorLoader getArtifactPluginDescriptorLoader() {
        return this.artifactPluginDescriptorLoader;
    }

    public DefaultDomainFactory getDomainFactory() {
        return this.domainFactory;
    }

    public DefaultApplicationFactory getApplicationFactory() {
        return this.applicationFactory;
    }

    public ToolingApplicationFactory getToolingApplicationFactory() {
        return this.toolingApplicationFactory;
    }

    public TemporaryApplicationFactory getTemporaryApplicationFactory() {
        return this.temporaryApplicationFactory;
    }

    public DefaultArtifactPluginRepository getArtifactPluginRepository() {
        return this.artifactPluginRepository;
    }

    public DeployableArtifactClassLoaderFactory<DomainDescriptor> getDomainClassLoaderFactory() {
        return this.domainClassLoaderFactory;
    }

    public ArtifactClassLoaderFactory<ArtifactPluginDescriptor> getArtifactPluginClassLoaderFactory() {
        return this.artifactPluginClassLoaderFactory;
    }

    public ArtifactClassLoader getContainerClassLoader() {
        return this.containerClassLoader;
    }

    public MuleServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public ExtensionModelLoaderManager getExtensionModelLoaderManager() {
        return this.extensionModelLoaderManager;
    }

    public DefaultClassLoaderManager getArtifactClassLoaderManager() {
        return this.artifactClassLoaderManager;
    }

    public ApplicationDescriptorFactory getApplicationDescriptorFactory() {
        return this.applicationDescriptorFactory;
    }

    public PluginDependenciesResolver getPluginDependenciesResolver() {
        return this.pluginDependenciesResolver;
    }

    public static class Builder {
        private ModuleRepository moduleRepository;

        public Builder moduleRepository(ModuleRepository moduleRepository) {
            Preconditions.checkArgument((moduleRepository != null ? 1 : 0) != 0, (String)"moduleRepository cannot be null");
            this.moduleRepository = moduleRepository;
            return this;
        }

        public MuleArtifactResourcesRegistry build() {
            if (this.moduleRepository == null) {
                this.moduleRepository = new DefaultModuleRepository((ModuleDiscoverer)new ContainerModuleDiscoverer(this.getClass().getClassLoader()));
            }
            return new MuleArtifactResourcesRegistry(this.moduleRepository);
        }
    }
}

