/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerClassLoaderCreatorUtils;
import org.mule.runtime.container.internal.PreFilteredContainerClassLoaderCreator;
import org.mule.runtime.core.internal.util.EnumerationAdapter;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class DefaultPreFilteredContainerClassLoaderCreator
implements PreFilteredContainerClassLoaderCreator {
    private final ModuleRepository moduleRepository;

    public DefaultPreFilteredContainerClassLoaderCreator(ModuleRepository moduleRepository) {
        Preconditions.checkArgument((moduleRepository != null ? 1 : 0) != 0, (String)"moduleRepository cannot be null");
        this.moduleRepository = moduleRepository;
    }

    @Override
    public List<MuleModule> getMuleModules() {
        return this.moduleRepository.getModules();
    }

    @Override
    public Set<String> getBootPackages() {
        return BOOT_PACKAGES;
    }

    @Override
    public ArtifactClassLoader getPreFilteredContainerClassLoader(ArtifactDescriptor artifactDescriptor, ClassLoader parentClassLoader) {
        return new MuleContainerClassLoader(artifactDescriptor, new URL[0], parentClassLoader, ContainerClassLoaderCreatorUtils.getLookupPolicy(parentClassLoader, this.getMuleModules(), this.getBootPackages()));
    }

    @Override
    public void close() throws Exception {
    }

    private static final class MuleContainerClassLoader
    extends MuleArtifactClassLoader {
        private MuleContainerClassLoader(ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
            super("container", artifactDescriptor, urls, parent, lookupPolicy);
        }

        public URL findResource(String name) {
            return null;
        }

        public Enumeration<URL> findResources(String name) throws IOException {
            return new EnumerationAdapter(Collections.emptyList());
        }

        static {
            MuleContainerClassLoader.registerAsParallelCapable();
        }
    }
}

