/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModuleRepository
implements ModuleRepository {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultModuleRepository.class);
    private final ModuleDiscoverer moduleDiscoverer;
    private volatile List<MuleModule> modules;

    public DefaultModuleRepository(ModuleDiscoverer moduleDiscoverer) {
        Preconditions.checkArgument((moduleDiscoverer != null ? 1 : 0) != 0, (String)"moduleDiscoverer cannot be null");
        this.moduleDiscoverer = moduleDiscoverer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MuleModule> getModules() {
        if (this.modules == null) {
            DefaultModuleRepository defaultModuleRepository = this;
            synchronized (defaultModuleRepository) {
                if (this.modules == null) {
                    this.modules = this.discoverModules();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Found {} modules: {}", (Object)this.modules.size(), this.modules.stream().map(m -> m.getName()).collect(Collectors.toList()));
                    }
                }
            }
        }
        return this.modules;
    }

    protected List<MuleModule> discoverModules() {
        return this.moduleDiscoverer.discover();
    }
}

