/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.boot.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.ServiceLoader;
import org.mule.runtime.jpms.api.JpmsUtils;
import org.mule.runtime.jpms.api.MultiLevelClassLoaderFactory;
import org.mule.runtime.module.boot.api.MuleContainer;
import org.mule.runtime.module.boot.api.MuleContainerProvider;
import org.mule.runtime.module.boot.internal.DefaultMuleClassPathConfig;
import org.mule.runtime.module.boot.internal.MuleContainerFactory;
import org.mule.runtime.module.boot.internal.util.SystemUtils;

public abstract class AbstractMuleContainerFactory
implements MuleContainerFactory {
    public static final String[][] CLI_OPTIONS = new String[][]{{"builder", "true", "Configuration Builder Type"}, {"config", "true", "Configuration File"}, {"idle", "false", "Whether to run in idle (unconfigured) mode"}, {"main", "true", "Main Class"}, {"mode", "true", "Run Mode"}, {"props", "true", "Startup Properties"}, {"production", "false", "Production Mode"}, {"debug", "false", "Configure Mule for JPDA remote debugging."}, {"app", "true", "Application to start"}};
    static final String APP_COMMAND_LINE_OPTION = "app";
    static final String DEPLOYMENT_APPLICATION_PROPERTY = "mule.deploy.applications";
    static final String INVALID_DEPLOY_APP_CONFIGURATION_ERROR = String.format("Cannot set both '%s' option and '%s' property", "app", "mule.deploy.applications");
    private final String muleHomeDirectoryPropertyName;
    private final String muleBaseDirectoryPropertyName;

    public AbstractMuleContainerFactory(String muleHomeDirectoryPropertyName, String muleBaseDirectoryPropertyName) {
        this.muleHomeDirectoryPropertyName = muleHomeDirectoryPropertyName;
        this.muleBaseDirectoryPropertyName = muleBaseDirectoryPropertyName;
    }

    @Override
    public final MuleContainer create(String[] args) throws Exception {
        this.validateCommnadLineOptions(args);
        return this.createMuleContainer();
    }

    private void validateCommnadLineOptions(String[] args) {
        Map<String, Object> commandlineOptions = SystemUtils.getCommandLineOptions(args, CLI_OPTIONS);
        String appOption = (String)commandlineOptions.get(APP_COMMAND_LINE_OPTION);
        if (appOption != null) {
            if (System.getProperty(DEPLOYMENT_APPLICATION_PROPERTY) != null) {
                throw new IllegalArgumentException(INVALID_DEPLOY_APP_CONFIGURATION_ERROR);
            }
            System.setProperty(DEPLOYMENT_APPLICATION_PROPERTY, appOption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MuleContainer createMuleContainer() throws IOException, Exception {
        ClassLoader muleSystemCl = this.createContainerSystemClassLoader(this.lookupMuleHome(), this.lookupMuleBase());
        MuleContainerProvider containerProvider = ServiceLoader.load(MuleContainerProvider.class, muleSystemCl).iterator().next();
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(muleSystemCl);
        try {
            MuleContainer muleContainer = containerProvider.provide();
            return muleContainer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    protected abstract DefaultMuleClassPathConfig createMuleClassPathConfig(File var1, File var2);

    private ClassLoader createContainerSystemClassLoader(File muleHome, File muleBase) {
        DefaultMuleClassPathConfig config = this.createMuleClassPathConfig(muleHome, muleBase);
        return JpmsUtils.createModuleLayerClassLoader((URL[])config.getOptURLs().toArray(new URL[config.getOptURLs().size()]), (URL[])config.getMuleURLs().toArray(new URL[config.getMuleURLs().size()]), (MultiLevelClassLoaderFactory)MultiLevelClassLoaderFactory.MULTI_LEVEL_URL_CLASSLOADER_FACTORY, (ClassLoader)ClassLoader.getSystemClassLoader());
    }

    private File lookupMuleHome() throws IOException {
        return this.lookupMuleDirectoryLocation(this.muleHomeDirectoryPropertyName, "%MULE_HOME%");
    }

    private File lookupMuleBase() throws IOException {
        return this.lookupMuleDirectoryLocation(this.muleBaseDirectoryPropertyName, "%MULE_BASE%");
    }

    private File lookupMuleDirectoryLocation(String muleDirectoryLocationPropertyName, String placeholderForNullValue) throws IOException {
        File muleBase = null;
        String muleBaseVar = System.getProperty(muleDirectoryLocationPropertyName);
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals(placeholderForNullValue)) {
            muleBase = new File(muleBaseVar).getCanonicalFile();
        }
        this.validateMuleDirectoryLocation(muleDirectoryLocationPropertyName, muleBase);
        return muleBase;
    }

    private void validateMuleDirectoryLocation(String muleDirectoryLocationPropertyName, File muleDirectoryLocation) throws IllegalArgumentException {
        if (muleDirectoryLocation == null) {
            throw new IllegalArgumentException("The system property " + muleDirectoryLocationPropertyName + " is not set.");
        }
        if (!muleDirectoryLocation.exists()) {
            throw new IllegalArgumentException("The system property " + muleDirectoryLocationPropertyName + " does not contain a valid directory (" + muleDirectoryLocation.getAbsolutePath() + ").");
        }
        if (!muleDirectoryLocation.isDirectory()) {
            throw new IllegalArgumentException("The system property " + muleDirectoryLocationPropertyName + " does not contain a valid directory (" + muleDirectoryLocation.getAbsolutePath() + ").");
        }
    }
}

