/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.boot.internal;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.module.boot.api.MuleContainer;
import org.mule.runtime.module.boot.internal.AbstractMuleContainerWrapper;
import org.mule.runtime.module.boot.internal.MuleContainerFactory;

public class MuleContainerBasicWrapper
extends AbstractMuleContainerWrapper {
    private MuleContainer muleContainer;
    private boolean isStarted = false;

    @Override
    protected void start(MuleContainerFactory muleContainerFactory, String[] args) {
        try {
            this.muleContainer = muleContainerFactory.create(args);
            this.startWithContainerClassLoader();
        }
        catch (Exception e) {
            this.muleContainer = null;
            throw new RuntimeException(e);
        }
    }

    @Override
    public void haltAndCatchFire(int exitCode, String message) {
        throw new RuntimeException(message);
    }

    @Override
    public void restart() {
        System.out.println("JVM requested a restart.");
    }

    @Override
    public void stop(int exitCode) {
        Throwable shutdownException = null;
        try {
            this.dispose();
        }
        catch (Throwable t) {
            shutdownException = t;
        }
        try {
            this.doStop();
            this.muleContainer = null;
        }
        catch (Throwable t) {
            shutdownException = t;
        }
        if (shutdownException != null) {
            shutdownException.printStackTrace();
            System.exit(-1);
        }
        System.exit(exitCode);
    }

    private void doStop() {
        try {
            if (this.muleContainer != null && this.isStarted) {
                this.muleContainer.shutdown();
                this.isStarted = false;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWithContainerClassLoader() throws Exception {
        String javaPid = this.getPid().map(String::valueOf).orElse("N/A");
        List<String> additionalSplashEntries = Collections.singletonList(String.format("Java PID: %s", javaPid));
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.muleContainer.getClass().getClassLoader());
        try {
            this.muleContainer.start(this.getAllConfigurersReady(), additionalSplashEntries);
            this.isStarted = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private Optional<Long> getPid() {
        try {
            Class<?> processHandleCls = Class.forName("java.lang.ProcessHandle");
            Object currentProcessHandle = processHandleCls.getMethod("current", new Class[0]).invoke(null, new Object[0]);
            return Optional.of(Long.valueOf((Long)processHandleCls.getMethod("pid", new Class[0]).invoke(currentProcessHandle, new Object[0])));
        }
        catch (ReflectiveOperationException e) {
            return Optional.empty();
        }
    }
}

