/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.artifact.classloader;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MvelClassLoaderReleaser
implements ResourceReleaser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MvelClassLoaderReleaser.class);
    private final MuleArtifactClassLoader muleArtifactClassLoader;

    public MvelClassLoaderReleaser(MuleArtifactClassLoader muleArtifactClassLoader) {
        this.muleArtifactClassLoader = muleArtifactClassLoader;
    }

    @Override
    public void release() {
        try {
            this.releaseFromASMAccessOptimizer();
            this.releaseFromDynamicOptimizer();
        }
        catch (Throwable t) {
            LOGGER.warn("Unexpected error while cleaning MVEL's ASMAccessorOptimizer and DynamicOptimizer class loaders", t);
        }
    }

    protected void releaseFromASMAccessOptimizer() {
        ClassLoader mvelCl;
        try {
            mvelCl = (ClassLoader)Class.forName("org.mule.mvel2.optimizers.impl.asm.ASMAccessorOptimizer").getMethod("getMVELClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException error) {
            return;
        }
        try {
            if (mvelCl != null && mvelCl.getParent() == this.muleArtifactClassLoader) {
                Class.forName("org.mule.mvel2.optimizers.impl.asm.ASMAccessorOptimizer").getMethod("setMVELClassLoader", Class.forName("org.mule.mvel2.util.MVELClassLoader")).invoke(null, new Object[]{null});
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to clean MVEL's ASMAccessorOptimizer class loader", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseFromDynamicOptimizer() {
        Field clField;
        try {
            clField = Class.forName("org.mule.mvel2.optimizers.dynamic.DynamicOptimizer").getDeclaredField("classLoader");
        }
        catch (ClassNotFoundException | NoSuchFieldException | SecurityException error) {
            return;
        }
        boolean accessible = clField.isAccessible();
        clField.setAccessible(true);
        try {
            ClassLoader mvelCl = (ClassLoader)clField.get(null);
            if (mvelCl != null && mvelCl.getParent() == this.muleArtifactClassLoader) {
                clField.set(null, null);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to clean MVEL's DynamicOptimizer class loader", t);
        }
        finally {
            clField.setAccessible(accessible);
        }
    }
}

