/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.artifact.classloader;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaClassValueReleaser
implements ResourceReleaser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScalaClassValueReleaser.class);
    private final Field classValueMapField;

    public ScalaClassValueReleaser() {
        Field classValueMapField = null;
        try {
            classValueMapField = Class.class.getDeclaredField("classValueMap");
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to initialize ScalaClassValueReleaser", t);
        }
        this.classValueMapField = classValueMapField;
    }

    @Override
    public void release() {
        try {
            WeakHashMap classValueMap = this.getClassValueMap();
            if (classValueMap != null) {
                Object[] cache = this.getCache(classValueMap);
                for (int i = 0; i < cache.length; ++i) {
                    Object object = cache[i];
                    if (object == null) continue;
                    Object value = this.resolveValue(object);
                    LOGGER.trace("Checking class value entry '{}' from '{}'...", value.getClass(), (Object)value.getClass().getClassLoader());
                    if (value.getClass().getClassLoader() instanceof MuleDeployableArtifactClassLoader || value.getClass().getClassLoader() != null && value.getClass().getClassLoader().getParent() instanceof RegionClassLoader) {
                        LOGGER.debug("Removing class value entry '{}' from '{}'", value.getClass(), (Object)value.getClass().getClassLoader());
                        Object key = null;
                        Set entrySet = classValueMap.entrySet();
                        for (Map.Entry entry : entrySet) {
                            if (this.resolveValue(entry.getValue()) != value) continue;
                            key = entry.getKey();
                            break;
                        }
                        classValueMap.remove(key);
                        cache[i] = null;
                        continue;
                    }
                    LOGGER.trace("NOT Removing class value entry '{}' from '{}'", value.getClass(), (Object)value.getClass().getClassLoader());
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to clean Scala's ClassValues", t);
        }
    }

    private WeakHashMap getClassValueMap() throws IllegalAccessException {
        if (this.classValueMapField == null) {
            return null;
        }
        this.classValueMapField.setAccessible(true);
        try {
            WeakHashMap weakHashMap = (WeakHashMap)this.classValueMapField.get(String.class);
            return weakHashMap;
        }
        finally {
            this.classValueMapField.setAccessible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getCache(WeakHashMap classValueMap) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method getCacheMethod = null;
        getCacheMethod = classValueMap.getClass().getDeclaredMethod("getCache", new Class[0]);
        if (getCacheMethod != null) {
            getCacheMethod.setAccessible(true);
            try {
                Object[] objectArray = (Object[])getCacheMethod.invoke((Object)classValueMap, new Object[0]);
                return objectArray;
            }
            finally {
                getCacheMethod.setAccessible(false);
            }
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object resolveValue(Object object) throws NoSuchFieldException, IllegalAccessException {
        Class<?> classValueEntryClass = object.getClass();
        Field classValueEntryValueField = classValueEntryClass.getDeclaredField("value");
        classValueEntryValueField.setAccessible(true);
        try {
            Object object2 = classValueEntryValueField.get(object);
            return object2;
        }
        finally {
            classValueEntryValueField.setAccessible(false);
        }
    }
}

