/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.artifact.classloader;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcResourceReleaser
implements ResourceReleaser {
    private static final String AVOID_DISPOSE_TIMER_THREADS_PROPERTY_NAME = "avoid.dispose.oracle.threads";
    private static final boolean JDBC_RESOURCE_RELEASER_AVOID_DISPOSE_TIMER_THREADS = Boolean.getBoolean("avoid.dispose.oracle.threads");
    public static final String DIAGNOSABILITY_BEAN_NAME = "diagnosability";
    public static final String DRIVER_TIMER_THREAD_CLASS_NAME = "TimerThread";
    public static final String COMPOSITE_CLASS_LOADER_CLASS_NAME = "CompositeClassLoader";
    public static final Pattern DRIVER_TIMER_THREAD_PATTERN = Pattern.compile("^Timer-\\d+");
    private static final Logger logger = LoggerFactory.getLogger(JdbcResourceReleaser.class);
    private static final List<String> CONNECTION_CLEANUP_THREAD_KNOWN_CLASS_ADDRESES = Arrays.asList("com.mysql.jdbc.AbandonedConnectionCleanupThread", "com.mysql.cj.jdbc.AbandonedConnectionCleanupThread");

    @Override
    public void release() {
        this.deregisterJdbcDrivers();
    }

    private void deregisterJdbcDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (this.isDriverLoadedByThisClassLoader(driver)) {
                this.doDeregisterDriver(driver);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug(String.format("Skipping deregister driver %s. It wasn't loaded by the classloader of the artifact being released.", driver.getClass()));
        }
        if (!JDBC_RESOURCE_RELEASER_AVOID_DISPOSE_TIMER_THREADS && this.detectDB2Uses()) {
            this.disposeDriverTimerThreads();
        }
    }

    private boolean isDriverLoadedByThisClassLoader(Driver driver) {
        for (ClassLoader driverClassLoader = driver.getClass().getClassLoader(); driverClassLoader != null; driverClassLoader = driverClassLoader.getParent()) {
            if (driverClassLoader != this.getClass().getClassLoader()) continue;
            return true;
        }
        return false;
    }

    private void doDeregisterDriver(Driver driver) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Deregistering driver: {}", driver.getClass());
            }
            DriverManager.deregisterDriver(driver);
            if (this.isOracleDriver(driver)) {
                this.deregisterOracleDiagnosabilityMBean();
                this.disposeDriverTimerThreads();
            }
            if (this.isMySqlDriver(driver)) {
                this.shutdownMySqlAbandonedConnectionCleanupThread();
            }
            if (this.isDerbyEmbeddedDriver(driver)) {
                this.leakPreventionForDerbyEmbeddedDriver(driver);
            }
        }
        catch (Exception e) {
            logger.warn(String.format("Can not deregister driver %s. This can cause a memory leak.", driver.getClass()), (Throwable)e);
        }
    }

    private boolean isOracleDriver(Driver driver) {
        return this.isDriver(driver, "oracle.jdbc.OracleDriver");
    }

    private boolean isMySqlDriver(Driver driver) {
        return this.isDriver(driver, "com.mysql.jdbc.Driver") || this.isDriver(driver, "com.mysql.cj.jdbc.Driver");
    }

    private boolean isDerbyEmbeddedDriver(Driver driver) {
        return this.isDriver(driver, "org.apache.derby.jdbc.AutoloadedDriver");
    }

    private boolean detectDB2Uses() {
        try {
            return this.getClass().getClassLoader().getResources("com/ibm/db2").hasMoreElements();
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isDriver(Driver driver, String expectedDriverClass) {
        try {
            return driver.getClass().getClassLoader().loadClass(expectedDriverClass).isAssignableFrom(driver.getClass());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void deregisterOracleDiagnosabilityMBean() {
        ClassLoader cl = this.getClass().getClassLoader();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Hashtable<String, String> keys = new Hashtable<String, String>();
        keys.put("type", DIAGNOSABILITY_BEAN_NAME);
        keys.put("name", cl.getClass().getName() + "@" + Integer.toHexString(cl.hashCode()).toLowerCase());
        try {
            mBeanServer.unregisterMBean(new ObjectName("com.oracle.jdbc", keys));
        }
        catch (InstanceNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("No Oracle's '%s' MBean found.", DIAGNOSABILITY_BEAN_NAME));
            }
        }
        catch (Throwable e) {
            logger.warn("Unable to unregister Oracle's mbeans", e);
        }
    }

    private void leakPreventionForDerbyEmbeddedDriver(Object driverObject) {
        try {
            if (this.hasDeclaredMethod(driverObject.getClass(), "connect", String.class, Properties.class)) {
                Method m = driverObject.getClass().getDeclaredMethod("connect", String.class, Properties.class);
                m.invoke(driverObject, "jdbc:derby:;shutdown=true", null);
            }
        }
        catch (Throwable e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Expected exception when unregister Derby's embedded driver", e);
                }
            }
            logger.warn("Unable to unregister Derby's embedded driver", e);
        }
    }

    private boolean hasDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes) != null;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    private void shutdownMySqlAbandonedConnectionCleanupThread() {
        try {
            Class<?> cleanupThreadsClass = this.findMySqlDriverClass();
            this.shutdownMySqlConnectionCleanupThreads(cleanupThreadsClass);
            this.cleanMySqlCleanupThreadsThreadFactory(cleanupThreadsClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.warn("Unable to shutdown MySql's AbandonedConnectionCleanupThread", (Throwable)e);
        }
    }

    private void cleanMySqlCleanupThreadsThreadFactory(Class<?> cleanupThreadsClass) {
        try {
            Field cleanupExecutorServiceField = cleanupThreadsClass.getDeclaredField("cleanupThreadExcecutorService");
            cleanupExecutorServiceField.setAccessible(true);
            ExecutorService delegateCleanupExecutorService = (ExecutorService)cleanupExecutorServiceField.get(cleanupThreadsClass);
            Field realExecutorServiceField = delegateCleanupExecutorService.getClass().getSuperclass().getDeclaredField("e");
            realExecutorServiceField.setAccessible(true);
            ThreadPoolExecutor realExecutorService = (ThreadPoolExecutor)realExecutorServiceField.get(delegateCleanupExecutorService);
            realExecutorService.setThreadFactory(Executors.defaultThreadFactory());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.warn("Error cleaning threadFactory from AbandonedConnectionCleanupThread executor service", (Throwable)e);
        }
    }

    private void shutdownMySqlConnectionCleanupThreads(Class<?> classAbandonedConnectionCleanupThread) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            Method uncheckedShutdown = classAbandonedConnectionCleanupThread.getMethod("uncheckedShutdown", new Class[0]);
            uncheckedShutdown.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Method checkedShutdown = classAbandonedConnectionCleanupThread.getMethod("shutdown", new Class[0]);
            checkedShutdown.invoke(null, new Object[0]);
        }
    }

    private Class<?> findMySqlDriverClass() throws ClassNotFoundException {
        for (String knownCleanupThreadClassAddress : CONNECTION_CLEANUP_THREAD_KNOWN_CLASS_ADDRESES) {
            try {
                return this.getClass().getClassLoader().loadClass(knownCleanupThreadClassAddress);
            }
            catch (ClassNotFoundException e) {
                logger.warn("No AbandonedConnectionCleanupThread registered with class address " + knownCleanupThreadClassAddress);
            }
        }
        throw new ClassNotFoundException("No MySql's AbandonedConnectionCleanupThread class was found");
    }

    private void disposeDriverTimerThreads() {
        try {
            if (JDBC_RESOURCE_RELEASER_AVOID_DISPOSE_TIMER_THREADS) {
                return;
            }
            Thread[] threads = new Thread[Thread.activeCount()];
            try {
                Thread.enumerate(threads);
            }
            catch (Throwable t) {
                logger.debug("An error occurred trying to obtain available Threads. Thread cleanup will be skipped.", t);
                return;
            }
            ClassLoader undeployedArtifactClassLoader = this.getClass().getClassLoader();
            for (Thread thread : threads) {
                if (!this.isTimerThread(undeployedArtifactClassLoader, thread)) continue;
                try {
                    this.clearReferencesStopTimerThread(thread);
                    thread.interrupt();
                    thread.join();
                }
                catch (Throwable e) {
                    logger.warn("An error occurred trying to close the '" + thread.getName() + "' Thread. This might cause memory leaks.", e);
                }
            }
        }
        catch (Exception e) {
            logger.error("An exception occurred while attempting to dispose of oracle timer threads: {}", (Object)e.getMessage());
        }
    }

    private boolean isTimerThread(ClassLoader undeployedArtifactClassLoader, Thread thread) {
        if (!(undeployedArtifactClassLoader instanceof ArtifactClassLoader)) {
            return false;
        }
        String artifactId = ((ArtifactClassLoader)((Object)undeployedArtifactClassLoader)).getArtifactId();
        Matcher timerThreadNameMatcher = DRIVER_TIMER_THREAD_PATTERN.matcher(thread.getName());
        return thread.getClass().getSimpleName().equals(DRIVER_TIMER_THREAD_CLASS_NAME) && timerThreadNameMatcher.matches() && (this.isThreadLoadedByDisposedApplication(artifactId, thread.getContextClassLoader()) || this.isThreadLoadedByDisposedDomain(artifactId, thread.getContextClassLoader()));
    }

    private boolean isThreadLoadedByDisposedDomain(String undeployedArtifactId, ClassLoader threadContextClassLoader) {
        try {
            Class<?> threadContextClassLoaderClass = threadContextClassLoader.getClass();
            if (!threadContextClassLoaderClass.getSimpleName().equals(COMPOSITE_CLASS_LOADER_CLASS_NAME)) {
                return false;
            }
            Method getDelegateClassLoadersMethod = threadContextClassLoaderClass.getMethod("getDelegates", new Class[0]);
            List classLoaderList = (List)getDelegateClassLoadersMethod.invoke((Object)threadContextClassLoader, new Object[0]);
            for (ClassLoader classLoaderDelegate : classLoaderList) {
                ArtifactClassLoader artifactClassLoader;
                if (!(classLoaderDelegate instanceof ArtifactClassLoader) || !(artifactClassLoader = (ArtifactClassLoader)((Object)classLoaderDelegate)).getArtifactId().contains(undeployedArtifactId)) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.warn("Exception occurred while attempting to compare {} and {} artifactId.", (Object)threadContextClassLoader, (Object)this.getClass().getClassLoader());
        }
        return false;
    }

    private boolean isThreadLoadedByDisposedApplication(String undeployedArtifactId, ClassLoader threadContextClassLoader) {
        try {
            if (!(threadContextClassLoader instanceof MuleArtifactClassLoader)) {
                return false;
            }
            String threadClassLoaderArtifactId = ((MuleArtifactClassLoader)threadContextClassLoader).getArtifactId();
            return threadClassLoaderArtifactId != null && threadClassLoaderArtifactId.equals(undeployedArtifactId);
        }
        catch (Exception e) {
            logger.warn("Exception occurred while attempting to compare {} and {} artifact id.", (Object)threadContextClassLoader, (Object)this.getClass().getClassLoader());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReferencesStopTimerThread(Thread thread) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        try {
            Field newTasksMayBeScheduledField = thread.getClass().getDeclaredField("newTasksMayBeScheduled");
            newTasksMayBeScheduledField.setAccessible(true);
            Field queueField = thread.getClass().getDeclaredField("queue");
            queueField.setAccessible(true);
            Object queue = queueField.get(thread);
            Method clearMethod = queue.getClass().getDeclaredMethod("clear", new Class[0]);
            clearMethod.setAccessible(true);
            Object object = queue;
            synchronized (object) {
                newTasksMayBeScheduledField.setBoolean(thread, false);
                clearMethod.invoke(queue, new Object[0]);
                queue.notifyAll();
                newTasksMayBeScheduledField.setAccessible(false);
                queueField.setAccessible(false);
                clearMethod.setAccessible(false);
            }
        }
        catch (NoSuchFieldException noSuchFieldEx) {
            logger.warn("Unable to clear timer references using 'clear' method. Attempting to use 'cancel' method.");
            Method cancelMethod = thread.getClass().getDeclaredMethod("cancel", new Class[0]);
            cancelMethod.setAccessible(true);
            cancelMethod.invoke((Object)thread, new Object[0]);
            cancelMethod.setAccessible(false);
        }
    }
}

