/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader.exception;

import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.exception.MuleException;

@NoInstantiate
public final class ClassNotFoundInRegionException
extends ClassNotFoundException {
    private static final long serialVersionUID = -2800293812538208279L;
    private String className;
    private String regionName;
    private String artifactName;

    public ClassNotFoundInRegionException(String className, String regionName) {
        super(String.format("Class '%s' has no package mapping for region '%s'.", className, regionName));
        this.className = className;
        this.regionName = regionName;
    }

    public ClassNotFoundInRegionException(String className, String regionName, String artifactName, ClassNotFoundException cause) {
        super(String.format("Class '%s' not found in classloader for artifact '%s' in region '%s'.", className, artifactName, regionName), cause);
        this.className = className;
        this.regionName = regionName;
        this.artifactName = artifactName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        if (MuleException.isVerboseExceptions()) {
            return super.fillInStackTrace();
        }
        return this;
    }
}

