/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.artifact.classloader;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceReleaser
implements ResourceReleaser {
    public static final String DIAGNOSABILITY_BEAN_NAME = "diagnosability";
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final List<String> CONNECTION_CLEANUP_THREAD_KNOWN_CLASS_ADDRESES = Arrays.asList("com.mysql.jdbc.AbandonedConnectionCleanupThread", "com.mysql.cj.jdbc.AbandonedConnectionCleanupThread");

    @Override
    public void release() {
        this.deregisterJdbcDrivers();
        this.shutdownAwsIdleConnectionReaperThread();
        this.cleanUpResourceBundle();
    }

    private void cleanUpResourceBundle() {
        try {
            ResourceBundle.clearCache(this.getClass().getClassLoader());
        }
        catch (Exception e) {
            this.logger.warn("Couldn't clean up ResourceBundle. This can cause a memory leak.", (Throwable)e);
        }
    }

    private void deregisterJdbcDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (this.isDriverLoadedByThisClassLoader(driver)) {
                this.doDeregisterDriver(driver);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug(String.format("Skipping deregister driver %s. It wasn't loaded by the classloader of the artifact being released.", driver.getClass()));
        }
    }

    private boolean isDriverLoadedByThisClassLoader(Driver driver) {
        for (ClassLoader driverClassLoader = driver.getClass().getClassLoader(); driverClassLoader != null; driverClassLoader = driverClassLoader.getParent()) {
            if (driverClassLoader != this.getClass().getClassLoader()) continue;
            return true;
        }
        return false;
    }

    private void doDeregisterDriver(Driver driver) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Deregistering driver: {}", driver.getClass());
            }
            DriverManager.deregisterDriver(driver);
            if (this.isOracleDriver(driver)) {
                this.deregisterOracleDiagnosabilityMBean();
            }
            if (this.isMySqlDriver(driver)) {
                this.shutdownMySqlAbandonedConnectionCleanupThread();
            }
            if (this.isDerbyEmbeddedDriver(driver)) {
                this.leakPreventionForDerbyEmbeddedDriver(driver);
            }
        }
        catch (Exception e) {
            this.logger.warn(String.format("Can not deregister driver %s. This can cause a memory leak.", driver.getClass()), (Throwable)e);
        }
    }

    private boolean isOracleDriver(Driver driver) {
        return this.isDriver(driver, "oracle.jdbc.OracleDriver");
    }

    private boolean isMySqlDriver(Driver driver) {
        return this.isDriver(driver, "com.mysql.jdbc.Driver") || this.isDriver(driver, "com.mysql.cj.jdbc.Driver");
    }

    private boolean isDerbyEmbeddedDriver(Driver driver) {
        return this.isDriver(driver, "org.apache.derby.jdbc.AutoloadedDriver");
    }

    private boolean isDriver(Driver driver, String expectedDriverClass) {
        try {
            return driver.getClass().getClassLoader().loadClass(expectedDriverClass).isAssignableFrom(driver.getClass());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void deregisterOracleDiagnosabilityMBean() {
        ClassLoader cl = this.getClass().getClassLoader();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Hashtable<String, String> keys = new Hashtable<String, String>();
        keys.put("type", DIAGNOSABILITY_BEAN_NAME);
        keys.put("name", cl.getClass().getName() + "@" + Integer.toHexString(cl.hashCode()).toLowerCase());
        try {
            mBeanServer.unregisterMBean(new ObjectName("com.oracle.jdbc", keys));
        }
        catch (InstanceNotFoundException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("No Oracle's '%s' MBean found.", DIAGNOSABILITY_BEAN_NAME));
            }
        }
        catch (Throwable e) {
            this.logger.warn("Unable to unregister Oracle's mbeans", e);
        }
    }

    private void leakPreventionForDerbyEmbeddedDriver(Object driverObject) {
        try {
            if (this.hasDeclaredMethod(driverObject.getClass(), "connect", String.class, Properties.class)) {
                Method m = driverObject.getClass().getDeclaredMethod("connect", String.class, Properties.class);
                m.invoke(driverObject, "jdbc:derby:;shutdown=true", null);
            }
        }
        catch (Throwable e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Expected exception when unregister Derby's embedded driver", e);
                }
            }
            this.logger.warn("Unable to unregister Derby's embedded driver", e);
        }
    }

    private boolean hasDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes) != null;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    private void shutdownMySqlAbandonedConnectionCleanupThread() {
        try {
            Class<?> cleanupThreadsClass = this.findMySqlDriverClass();
            this.shutdownMySqlConnectionCleanupThreads(cleanupThreadsClass);
            this.cleanMySqlCleanupThreadsThreadFactory(cleanupThreadsClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.warn("Unable to shutdown MySql's AbandonedConnectionCleanupThread", (Throwable)e);
        }
    }

    private void cleanMySqlCleanupThreadsThreadFactory(Class<?> cleanupThreadsClass) {
        try {
            Field cleanupExecutorServiceField = cleanupThreadsClass.getDeclaredField("cleanupThreadExcecutorService");
            cleanupExecutorServiceField.setAccessible(true);
            ExecutorService delegateCleanupExecutorService = (ExecutorService)cleanupExecutorServiceField.get(cleanupThreadsClass);
            Field realExecutorServiceField = delegateCleanupExecutorService.getClass().getSuperclass().getDeclaredField("e");
            realExecutorServiceField.setAccessible(true);
            ThreadPoolExecutor realExecutorService = (ThreadPoolExecutor)realExecutorServiceField.get(delegateCleanupExecutorService);
            realExecutorService.setThreadFactory(Executors.defaultThreadFactory());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.logger.warn("Error cleaning threadFactory from AbandonedConnectionCleanupThread executor service", (Throwable)e);
        }
    }

    private void shutdownMySqlConnectionCleanupThreads(Class<?> classAbandonedConnectionCleanupThread) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            Method uncheckedShutdown = classAbandonedConnectionCleanupThread.getMethod("uncheckedShutdown", new Class[0]);
            uncheckedShutdown.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Method checkedShutdown = classAbandonedConnectionCleanupThread.getMethod("shutdown", new Class[0]);
            checkedShutdown.invoke(null, new Object[0]);
        }
    }

    private Class<?> findMySqlDriverClass() throws ClassNotFoundException {
        Object foundClass = null;
        for (String knownCleanupThreadClassAddress : CONNECTION_CLEANUP_THREAD_KNOWN_CLASS_ADDRESES) {
            try {
                return this.getClass().getClassLoader().loadClass(knownCleanupThreadClassAddress);
            }
            catch (ClassNotFoundException e) {
                this.logger.warn("No AbandonedConnectionCleanupThread registered with class address " + knownCleanupThreadClassAddress);
            }
        }
        throw new ClassNotFoundException("No MySql's AbandonedConnectionCleanupThread class was found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownAwsIdleConnectionReaperThread() {
        try {
            Class<?> idleConnectionReaperClass = this.getClass().getClassLoader().loadClass("com.amazonaws.http.IdleConnectionReaper");
            try {
                Method registeredManagersMethod = idleConnectionReaperClass.getMethod("getRegisteredConnectionManagers", new Class[0]);
                List httpClientConnectionManagers = (List)registeredManagersMethod.invoke(null, new Object[0]);
                if (httpClientConnectionManagers.isEmpty()) {
                    return;
                }
                Class<?> httpClientConnectionManagerClass = this.getClass().getClassLoader().loadClass("org.apache.http.conn.HttpClientConnectionManager");
                Method removeConnectionManager = idleConnectionReaperClass.getMethod("removeConnectionManager", httpClientConnectionManagerClass);
                for (Object connectionManager : httpClientConnectionManagers) {
                    boolean removed = (Boolean)removeConnectionManager.invoke(null, connectionManager);
                    if (removed || !this.logger.isDebugEnabled()) continue;
                    this.logger.debug(String.format("Unable to unregister HttpClientConnectionManager instance [%s] associated to AWS's IdleConnectionReaperThread", connectionManager));
                }
            }
            finally {
                Method shutdown = idleConnectionReaperClass.getMethod("shutdown", new Class[0]);
                shutdown.invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException shutdown) {
        }
        catch (IllegalAccessException | SecurityException | InvocationTargetException e) {
            this.logger.warn("Unable to shutdown AWS's IdleConnectionReaperThread, an error occurred: " + e.getMessage(), (Throwable)e);
        }
    }
}

