/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.classloader;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.DirectoryResourceLocator;
import org.mule.runtime.module.artifact.classloader.FineGrainedControlClassLoader;
import org.mule.runtime.module.artifact.classloader.LocalResourceLocator;
import org.mule.runtime.module.artifact.classloader.ResourceReleaser;
import org.mule.runtime.module.artifact.classloader.ShutdownListener;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;

public class MuleArtifactClassLoader
extends FineGrainedControlClassLoader
implements ArtifactClassLoader {
    private static final String DEFAULT_RESOURCE_RELEASER_CLASS_LOCATION = "/org/mule/module/artifact/classloader/DefaultResourceReleaser.class";
    protected List<ShutdownListener> shutdownListeners = new ArrayList<ShutdownListener>();
    private final String artifactId;
    private LocalResourceLocator localResourceLocator;
    private String resourceReleaserClassLocation = "/org/mule/module/artifact/classloader/DefaultResourceReleaser.class";
    private ArtifactDescriptor artifactDescriptor;

    public MuleArtifactClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        super(urls, parent, lookupPolicy);
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)artifactId) ? 1 : 0) != 0, (String)"artifactId cannot be empty");
        Preconditions.checkArgument((artifactDescriptor != null ? 1 : 0) != 0, (String)"artifactDescriptor cannot be null");
        this.artifactId = artifactId;
        this.artifactDescriptor = artifactDescriptor;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public <T extends ArtifactDescriptor> T getArtifactDescriptor() {
        return (T)this.artifactDescriptor;
    }

    protected String[] getLocalResourceLocations() {
        return new String[0];
    }

    @Override
    public ClassLoader getClassLoader() {
        return this;
    }

    @Override
    public void addShutdownListener(ShutdownListener listener) {
        this.shutdownListeners.add(listener);
    }

    @Override
    public void dispose() {
        try {
            this.createResourceReleaserInstance().release();
        }
        catch (Exception e) {
            this.logger.error("Cannot create resource releaser instance", (Throwable)e);
        }
        super.dispose();
        this.shutdownListeners();
    }

    private void shutdownListeners() {
        for (ShutdownListener listener : this.shutdownListeners) {
            try {
                listener.execute();
            }
            catch (Exception e) {
                this.logger.error("Error executing shutdown listener", (Throwable)e);
            }
        }
        this.shutdownListeners.clear();
    }

    public void setResourceReleaserClassLocation(String resourceReleaserClassLocation) {
        this.resourceReleaserClassLocation = resourceReleaserClassLocation;
    }

    protected ResourceReleaser createResourceReleaserInstance() {
        ResourceReleaser resourceReleaser;
        InputStream classStream = null;
        try {
            classStream = this.getClass().getResourceAsStream(this.resourceReleaserClassLocation);
            byte[] classBytes = IOUtils.toByteArray((InputStream)classStream);
            classStream.close();
            Class<?> clazz = this.defineClass(null, classBytes, 0, classBytes.length);
            resourceReleaser = (ResourceReleaser)clazz.newInstance();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Can not create resource releaser instance from resource: " + this.resourceReleaserClassLocation, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(classStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)classStream);
        return resourceReleaser;
    }

    @Override
    public URL findLocalResource(String resourceName) {
        return this.getLocalResourceLocator().findLocalResource(resourceName);
    }

    private LocalResourceLocator getLocalResourceLocator() {
        if (this.localResourceLocator == null) {
            this.localResourceLocator = new DirectoryResourceLocator(this.getLocalResourceLocations());
        }
        return this.localResourceLocator;
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.getArtifactId(), Integer.toHexString(System.identityHashCode(this)));
    }

    static {
        MuleArtifactClassLoader.registerAsParallelCapable();
    }
}

