/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.classloader.exception;

import org.mule.runtime.module.artifact.classloader.ClassLoaderFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotExportedClassException
extends ClassNotFoundException {
    private static final Logger logger = LoggerFactory.getLogger(NotExportedClassException.class);
    private static final long serialVersionUID = 2510347069070514569L;
    private String className;
    private String artifactName;
    private ClassLoaderFilter filter;

    public NotExportedClassException(String className, String artifactName, ClassLoaderFilter filter) {
        super(String.format("Class '%s' not found in classloader for artifact '%s'.", className, artifactName));
        this.className = className;
        this.artifactName = artifactName;
        this.filter = filter;
    }

    public String getClassName() {
        return this.className;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public ClassLoaderFilter getFilter() {
        return this.filter;
    }

    @Override
    public String getMessage() {
        if (Boolean.valueOf(System.getProperty("mule.classloading.verbose")).booleanValue() || logger.isTraceEnabled()) {
            return super.getMessage() + System.lineSeparator() + this.filter.toString();
        }
        return super.getMessage();
    }
}

