/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.module.artifact.classloader.LocalResourceLocator;

public class DirectoryResourceLocator
implements LocalResourceLocator {
    private String[] directories;

    public DirectoryResourceLocator(String ... directories) {
        this.directories = directories;
    }

    @Override
    public URL findLocalResource(String resourceName) {
        if (this.directories != null && resourceName != null) {
            for (String directory : this.directories) {
                File resourceFile = new File(directory, resourceName);
                if (!resourceFile.exists()) continue;
                try {
                    return resourceFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)String.format("Can not load resource with name %s.", resourceName)), (Throwable)e);
                }
            }
        }
        return null;
    }
}

