/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.extension.discovery;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.provider.RuntimeExtensionModelProviderLoaderUtils;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelDiscoverer;
import org.mule.runtime.module.artifact.activation.internal.PluginsDependenciesProcessor;
import org.mule.runtime.module.artifact.activation.internal.extension.discovery.ExtensionModelGenerator;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;

public class DefaultExtensionModelDiscoverer
implements ExtensionModelDiscoverer {
    private final ExtensionModelGenerator extensionModelGenerator;

    public DefaultExtensionModelDiscoverer(ExtensionModelGenerator extensionModelGenerator) {
        this.extensionModelGenerator = extensionModelGenerator;
    }

    @Override
    public Set<ExtensionModel> discoverPluginsExtensionModels(ExtensionDiscoveryRequest discoveryRequest) {
        Set runtimeExtensionModels = RuntimeExtensionModelProviderLoaderUtils.discoverRuntimeExtensionModels();
        List pluginDependenciesExtensionModels = PluginsDependenciesProcessor.process(discoveryRequest.getArtifactPluginDescriptors(), discoveryRequest.isParallelDiscovery(), (extensions, artifactPlugin) -> {
            HashSet<ExtensionModel> dependencies = new HashSet<ExtensionModel>();
            dependencies.addAll((Collection<ExtensionModel>)extensions);
            dependencies.addAll(discoveryRequest.getParentArtifactExtensions());
            dependencies.addAll(runtimeExtensionModels);
            ExtensionModel extension = this.extensionModelGenerator.obtainExtensionModel(discoveryRequest, (ArtifactPluginDescriptor)artifactPlugin, (Set<ExtensionModel>)dependencies);
            if (extension != null) {
                extensions.add(extension);
            }
        });
        return Stream.concat(runtimeExtensionModels.stream(), pluginDependenciesExtensionModels.stream()).collect(Collectors.toSet());
    }
}

