/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.descriptor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.nio.file.Path;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.mule.runtime.module.artifact.activation.api.descriptor.MuleConfigurationsFilter;

public class XmlMuleConfigurationsFilter
implements MuleConfigurationsFilter {
    private static final String DEFAULT_NAMESPACE_URI_MASK = "http://www.mulesoft.org/schema/mule/%s";
    private static final String CORE_NAMESPACE = String.format("http://www.mulesoft.org/schema/mule/%s", "core");
    private static final String DOMAIN_NAMESPACE = String.format("http://www.mulesoft.org/schema/mule/%s", "domain");
    private static final String CONFIG_FILE_EXTENSION = ".xml";
    private static final String muleLocalName = "mule";
    private static final String muleDomainLocalName = "mule-domain";
    private final XMLInputFactory factory = XMLInputFactory.newInstance();

    @Override
    public boolean filter(File candidateConfig) {
        return candidateConfig.getName().endsWith(CONFIG_FILE_EXTENSION) && this.hasMuleAsRootElement(this.generateDocument(candidateConfig.toPath()));
    }

    private boolean hasMuleAsRootElement(QName docRootTagName) {
        if (docRootTagName != null) {
            String rootElementLocalName = docRootTagName.getLocalPart();
            String rootElementNamespace = docRootTagName.getNamespaceURI();
            return rootElementLocalName.equals(muleLocalName) && rootElementNamespace.equals(CORE_NAMESPACE) || rootElementLocalName.equals(muleDomainLocalName) && rootElementNamespace.equals(DOMAIN_NAMESPACE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QName generateDocument(Path filePath) {
        XMLEventReader eventReader = null;
        try {
            XMLEvent event;
            eventReader = this.factory.createXMLEventReader(new FileReader(filePath.toFile()));
            while (eventReader.hasNext()) {
                event = eventReader.nextEvent();
                if (!event.isStartElement()) continue;
                QName qName = ((StartElement)event).getName();
                return qName;
            }
            event = null;
            return event;
        }
        catch (FileNotFoundException | XMLStreamException e) {
            QName qName = null;
            return qName;
        }
        finally {
            if (eventReader == null) {
                return null;
            }
            try {
                eventReader.close();
            }
            catch (XMLStreamException e) {
                return null;
            }
        }
    }
}

