/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.extension.discovery;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginClassLoaderSupplier;
import org.mule.runtime.module.artifact.activation.internal.extension.discovery.ExtensionModelGenerator;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.plugin.LoaderDescriber;

public class RepositoryLookupExtensionModelGenerator
implements ExtensionModelGenerator {
    private final PluginClassLoaderSupplier classLoaderFactory;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;

    public RepositoryLookupExtensionModelGenerator(PluginClassLoaderSupplier classLoaderFactory, ExtensionModelLoaderRepository extensionModelLoaderRepository) {
        this.classLoaderFactory = classLoaderFactory;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
    }

    @Override
    public ExtensionModel obtainExtensionModel(ExtensionDiscoveryRequest discoveryRequest, ArtifactPluginDescriptor artifactPluginDescriptor, Set<ExtensionModel> dependencies) {
        HashMap<String, Object> additionalAttributes = new HashMap<String, Object>(discoveryRequest.getParameters());
        if (!discoveryRequest.isEnrichDescriptions()) {
            additionalAttributes.put("EXTENSION_LOADER_DISABLE_DESCRIPTIONS_ENRICHMENT", true);
        }
        return artifactPluginDescriptor.getExtensionModelDescriptorProperty().map(describer -> this.discoverExtensionThroughJsonDescriber(this.extensionModelLoaderRepository, (LoaderDescriber)describer, dependencies, () -> this.classLoaderFactory.get(artifactPluginDescriptor).getClassLoader(), artifactPluginDescriptor.getName(), (Map<String, Object>)additionalAttributes, artifactPluginDescriptor, discoveryRequest.isOCSEnabled(), discoveryRequest.isForceExtensionValidation())).orElse(null);
    }

    private ExtensionModel discoverExtensionThroughJsonDescriber(ExtensionModelLoaderRepository extensionModelLoaderRepository, LoaderDescriber loaderDescriber, Set<ExtensionModel> dependencies, Supplier<ClassLoader> artifactClassloader, String artifactName, Map<String, Object> additionalAttributes, ArtifactPluginDescriptor artifactPluginDescriptor, boolean ocsEnabled, boolean forceExtensionValidation) {
        ExtensionModelLoader loader = extensionModelLoaderRepository.getExtensionModelLoader(loaderDescriber).orElseThrow(() -> new IllegalArgumentException(String.format("The identifier '%s' does not match with the describers available to generate an ExtensionModel (working with the plugin '%s')", loaderDescriber.getId(), artifactName)));
        HashMap<String, Object> attributes = new HashMap<String, Object>(loaderDescriber.getAttributes());
        attributes.putAll(additionalAttributes);
        return loader.loadExtensionModel(ExtensionModelLoadingRequest.builder((ClassLoader)artifactClassloader.get(), (DslResolvingContext)DslResolvingContext.getDefault(dependencies)).addParameters(attributes).setOCSEnabled(ocsEnabled).setForceExtensionValidation(forceExtensionValidation).setArtifactCoordinates((ArtifactCoordinates)artifactPluginDescriptor.getBundleDescriptor()).build());
    }
}

