/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.api.deployable;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.deployable.MuleProjectStructure;
import org.mule.runtime.module.artifact.activation.internal.deployable.MuleDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.activation.internal.maven.MavenDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.activation.internal.maven.MavenRefreshDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;

public interface DeployableProjectModelBuilder {
    public static DeployableProjectModelBuilder forMuleProject(File projectFolder, Optional<MuleDeployableModel> model) {
        return new MuleDeployableProjectModelBuilder(projectFolder, model);
    }

    public static DeployableProjectModelBuilder forMavenProject(File projectFolder, boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, boolean includeTestDependencies) {
        return new MavenDeployableProjectModelBuilder(projectFolder, exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, includeTestDependencies);
    }

    public static DeployableProjectModelBuilder forMavenRefreshProject(MuleProjectStructure projectStructure, ArtifactCoordinates deployableArtifactCoordinates, boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, List<BundleDependency> deployableBundleDependencies, Set<BundleDescriptor> sharedDeployableBundleDescriptors, Map<BundleDescriptor, List<BundleDependency>> additionalPluginDependencies) {
        return new MavenRefreshDeployableProjectModelBuilder(projectStructure, deployableArtifactCoordinates, exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, deployableBundleDependencies, sharedDeployableBundleDescriptors, additionalPluginDependencies);
    }

    public DeployableProjectModel build();
}

