/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.api.extension.discovery.boot;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.internal.spi.ExtensionsApiSpiUtils;

public final class ExtensionLoaderUtils {
    public static Stream<ExtensionModelLoader> lookupExtensionModelLoaders() {
        return ExtensionsApiSpiUtils.loadExtensionModelLoaderProviders().flatMap(p -> p.getExtensionModelLoaders().stream());
    }

    public static ExtensionModelLoader getLoaderById(String id) {
        return ExtensionLoaderUtils.getOptionalLoaderById(id).orElseThrow(() -> new NoSuchElementException("No loader found for id:{" + id + "}"));
    }

    public static Optional<ExtensionModelLoader> getOptionalLoaderById(String id) {
        return ExtensionLoaderUtils.lookupExtensionModelLoaders().filter(extensionModelLoader -> extensionModelLoader.getId().equals(id)).findFirst();
    }

    public static boolean isParallelExtensionModelLoadingEnabled() {
        return true;
    }

    private ExtensionLoaderUtils() {
    }
}

