/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.plugin;

import com.vdurmont.semver4j.Semver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLocalDependenciesDenylist {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginLocalDependenciesDenylist.class);
    private static final List<BundleDescriptor> PLUGINS_DENYLIST;

    public static boolean isDenylisted(BundleDescriptor pluginDescriptor) {
        if (PLUGINS_DENYLIST.stream().anyMatch(denylistedPluginDescriptor -> PluginLocalDependenciesDenylist.doDescriptorsMatch(denylistedPluginDescriptor, pluginDescriptor))) {
            LOGGER.warn("Plugin '{}' local dependencies won't have precedence over the dependencies of the artifact being deployed. Please update to the latest plugin version", (Object)pluginDescriptor);
            return true;
        }
        return false;
    }

    private static boolean doDescriptorsMatch(BundleDescriptor denylistedDescriptor, BundleDescriptor pluginBundleDescriptor) {
        if (!PluginLocalDependenciesDenylist.doGroupsMatch(denylistedDescriptor, pluginBundleDescriptor)) {
            return false;
        }
        if (!PluginLocalDependenciesDenylist.doArtifactIdsMatch(denylistedDescriptor, pluginBundleDescriptor)) {
            return false;
        }
        return PluginLocalDependenciesDenylist.isDenylistedVersionGreaterOrEqual(denylistedDescriptor.getVersion(), pluginBundleDescriptor.getVersion());
    }

    private static boolean isDenylistedVersionGreaterOrEqual(String denylistedVersion, String pluginVersion) {
        Semver denylistedSemver = new Semver(denylistedVersion);
        Semver pluginSemver = new Semver(pluginVersion);
        return !denylistedSemver.isLowerThan(pluginSemver);
    }

    private static boolean doGroupsMatch(BundleDescriptor first, BundleDescriptor second) {
        return first.getGroupId().equals(second.getGroupId());
    }

    private static boolean doArtifactIdsMatch(BundleDescriptor first, BundleDescriptor second) {
        return first.getArtifactId().equals(second.getArtifactId());
    }

    static {
        ArrayList<BundleDescriptor> denylist = new ArrayList<BundleDescriptor>();
        denylist.add(new BundleDescriptor.Builder().setGroupId("com.mulesoft.connectors").setArtifactId("mule-ibm-ctg-connector").setVersion("2.3.1").build());
        denylist.add(new BundleDescriptor.Builder().setGroupId("com.mulesoft.connectors").setArtifactId("mule-microsoft-dynamics-nav-connector").setVersion("2.0.1").build());
        PLUGINS_DENYLIST = Collections.unmodifiableList(denylist);
    }
}

