/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.descriptor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.internal.dsl.DslConstants;
import org.mule.runtime.module.artifact.activation.api.descriptor.MuleConfigurationsFilter;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlMuleConfigurationsFilter
implements MuleConfigurationsFilter {
    private static final String CONFIG_FILE_EXTENSION = ".xml";
    private static final String muleLocalName = "mule";
    private static final String muleDomainLocalName = "mule-domain";

    @Override
    public boolean filter(File candidateConfig) {
        return candidateConfig.getName().endsWith(CONFIG_FILE_EXTENSION) && this.hasMuleAsRootElement(this.generateDocument(candidateConfig.toPath()));
    }

    private boolean hasMuleAsRootElement(Document doc) {
        if (doc != null && doc.getDocumentElement() != null) {
            String rootElementLocalName = doc.getDocumentElement().getLocalName();
            String rootElementNamespace = doc.getDocumentElement().getNamespaceURI();
            return rootElementLocalName.equals(muleLocalName) && rootElementNamespace.equals(DslConstants.CORE_NAMESPACE) || rootElementLocalName.equals(muleDomainLocalName) && rootElementNamespace.equals(DslConstants.DOMAIN_NAMESPACE);
        }
        return false;
    }

    private Document generateDocument(Path filePath) {
        DocumentBuilderFactory documentBuilderFactory = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            return documentBuilderFactory.newDocumentBuilder().parse(filePath.toFile());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return null;
        }
    }
}

