/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.ast;

import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.module.artifact.activation.api.ast.AstXmlParserSupplier;
import org.mule.runtime.module.artifact.activation.internal.ast.MuleSdkExtensionModelLoadingMediator;

public class ArtifactAstUtils {
    public static ArtifactAst parseArtifact(String[] configResources, AstXmlParserSupplier parserSupplier, Set<ExtensionModel> extensions, boolean disableValidations, ClassLoader artifactClassLoader, MuleSdkExtensionModelLoadingMediator extensionModelMediator) throws ConfigurationException {
        ArtifactAst partialAst = ArtifactAstUtils.doParseArtifactIntoAst(configResources, parserSupplier, extensions, true, artifactClassLoader);
        Optional<ExtensionModel> extensionModel = extensionModelMediator.loadExtensionModel(partialAst, artifactClassLoader.getParent(), extensions);
        if (extensionModel.isPresent()) {
            HashSet<ExtensionModel> enrichedExtensionModels = new HashSet<ExtensionModel>(extensions);
            enrichedExtensionModels.add(extensionModel.get());
            return ArtifactAstUtils.doParseArtifactIntoAst(configResources, parserSupplier, enrichedExtensionModels, disableValidations, artifactClassLoader);
        }
        return disableValidations ? partialAst : ArtifactAstUtils.doParseArtifactIntoAst(configResources, parserSupplier, extensions, false, artifactClassLoader);
    }

    private static ArtifactAst doParseArtifactIntoAst(String[] configResources, AstXmlParserSupplier parserSupplier, Set<ExtensionModel> extensions, boolean disableValidations, ClassLoader artifactClassLoader) throws ConfigurationException {
        return parserSupplier.getParser(extensions, disableValidations).parse(ArtifactAstUtils.loadConfigResources(configResources, artifactClassLoader));
    }

    private static ConfigResource[] loadConfigResources(String[] configs, ClassLoader artifactClassLoader) throws ConfigurationException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ClassUtils.setContextClassLoader((Thread)Thread.currentThread(), (ClassLoader)currentClassLoader, (ClassLoader)artifactClassLoader);
        try {
            ConfigResource[] artifactConfigResources = new ConfigResource[configs.length];
            for (int i = 0; i < configs.length; ++i) {
                artifactConfigResources[i] = new ConfigResource(configs[i]);
            }
            ConfigResource[] configResourceArray = artifactConfigResources;
            return configResourceArray;
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            ClassUtils.setContextClassLoader((Thread)Thread.currentThread(), (ClassLoader)artifactClassLoader, (ClassLoader)currentClassLoader);
        }
    }

    private ArtifactAstUtils() {
    }
}

