/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.ast.validation;

import java.util.Collection;
import java.util.stream.Collectors;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.slf4j.Logger;

public class AstValidationUtils {
    private AstValidationUtils() {
    }

    public static void logWarningsAndThrowIfContainsErrors(ValidationResult validationResult, Logger logger) throws ConfigurationException {
        Collection items = validationResult.getItems();
        items.stream().filter(v -> v.getValidation().getLevel().equals((Object)Validation.Level.WARN)).forEach(v -> logger.warn(AstValidationUtils.validationResultItemToString(v)));
        boolean hasErrors = items.stream().anyMatch(v -> v.getValidation().getLevel().equals((Object)Validation.Level.ERROR));
        if (hasErrors) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)validationResult.getItems().stream().map(AstValidationUtils::validationResultItemToString).collect(Collectors.joining(System.lineSeparator()))));
        }
    }

    private static String validationResultItemToString(ValidationResultItem v) {
        return v.getComponents().stream().map(component -> component.getMetadata().getFileName().orElse("unknown") + ":" + component.getMetadata().getStartLine().orElse(-1)).collect(Collectors.joining("; ", "[", "]")) + ": " + v.getMessage();
    }
}

