/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.activation.internal.classloader.AbstractArtifactClassLoaderConfigurationAssembler;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.ClassLoaderModelAssembler;
import org.mule.runtime.module.artifact.activation.internal.plugin.NullPluginPatchesResolver;
import org.mule.runtime.module.artifact.activation.internal.plugin.PluginLocalDependenciesDenylist;
import org.mule.runtime.module.artifact.activation.internal.plugin.PluginPatchesResolver;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class PluginClassLoaderConfigurationAssembler
extends AbstractArtifactClassLoaderConfigurationAssembler {
    private final File artifactLocation;
    private final List<BundleDependency> bundleDependencies;
    private final BundleDependency bundleDependency;
    private final DeployableArtifactDescriptor ownerDescriptor;
    private final PluginPatchesResolver pluginPatchesResolver;

    public PluginClassLoaderConfigurationAssembler(BundleDependency bundleDependency, Set<BundleDescriptor> sharedProjectDependencies, File artifactLocation, MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor, List<BundleDependency> bundleDependencies, DeployableArtifactDescriptor ownerDescriptor) {
        super(new ClassLoaderModelAssembler(new ArtifactCoordinates(bundleDependency.getDescriptor().getGroupId(), bundleDependency.getDescriptor().getArtifactId(), bundleDependency.getDescriptor().getVersion(), bundleDependency.getDescriptor().getType(), (String)bundleDependency.getDescriptor().getClassifier().orElse(null)), bundleDependencies, sharedProjectDependencies, PluginClassLoaderConfigurationAssembler.attributeToList(bundleDependency.getPackages()), PluginClassLoaderConfigurationAssembler.attributeToList(bundleDependency.getResources())).createClassLoaderModel(), muleArtifactLoaderDescriptor);
        this.artifactLocation = artifactLocation;
        this.bundleDependencies = bundleDependencies;
        this.bundleDependency = bundleDependency;
        this.ownerDescriptor = ownerDescriptor;
        Collection resolverRegistered = new SpiServiceRegistry().lookupProviders(PluginPatchesResolver.class, this.getClass().getClassLoader());
        if (resolverRegistered.size() > 1) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("There is more than 1 PluginPatchesResolver implementation registered: " + resolverRegistered)));
        }
        this.pluginPatchesResolver = resolverRegistered.isEmpty() ? new NullPluginPatchesResolver() : (PluginPatchesResolver)resolverRegistered.iterator().next();
    }

    private static List<String> attributeToList(Set<String> attribute) {
        return attribute != null ? new ArrayList<String>(attribute) : Collections.emptyList();
    }

    protected List<URL> addArtifactSpecificClassLoaderConfiguration(ClassLoaderConfiguration.ClassLoaderConfigurationBuilder classLoaderConfigurationBuilder) {
        this.pluginPatchesResolver.resolve(this.getPackagerClassLoaderModel().getArtifactCoordinates()).forEach(arg_0 -> ((ClassLoaderConfiguration.ClassLoaderConfigurationBuilder)classLoaderConfigurationBuilder).containing(arg_0));
        ArrayList<URL> dependenciesArtifactsUrls = new ArrayList<URL>();
        if (this.ownerDescriptor != null) {
            this.ownerDescriptor.getClassLoaderConfiguration().getDependencies().stream().filter(bundleDescriptor -> bundleDescriptor.getDescriptor().isPlugin()).filter(bundleDescriptor -> bundleDescriptor.getDescriptor().getGroupId().equals(this.bundleDependency.getDescriptor().getGroupId()) && bundleDescriptor.getDescriptor().getArtifactId().equals(this.bundleDependency.getDescriptor().getArtifactId())).filter(bundleDependency -> bundleDependency.getAdditionalDependenciesList() != null && !bundleDependency.getAdditionalDependenciesList().isEmpty()).forEach(bundleDependency -> this.processPluginAdditionalDependenciesURIs((BundleDependency)bundleDependency, classLoaderConfigurationBuilder).forEach(uri -> {
                URL dependencyArtifactUrl;
                try {
                    dependencyArtifactUrl = uri.toURL();
                }
                catch (MalformedURLException e) {
                    throw new ArtifactActivationException(I18nMessageFactory.createStaticMessage((String)String.format("There was an exception obtaining the URL for the artifact [%s], file [%s]", this.bundleDependency.getDescriptor().getArtifactFileName(), uri)), e);
                }
                dependenciesArtifactsUrls.add(dependencyArtifactUrl);
            }));
        }
        return dependenciesArtifactsUrls;
    }

    private List<URI> processPluginAdditionalDependenciesURIs(BundleDependency bundleDependency, ClassLoaderConfiguration.ClassLoaderConfigurationBuilder classLoaderConfigurationBuilder) {
        return bundleDependency.getAdditionalDependenciesList().stream().map(additionalDependency -> {
            if (!PluginLocalDependenciesDenylist.isDenylisted(additionalDependency.getDescriptor())) {
                classLoaderConfigurationBuilder.withLocalPackages(additionalDependency.getPackages());
                classLoaderConfigurationBuilder.withLocalResources(additionalDependency.getResources());
            }
            return additionalDependency.getBundleUri();
        }).collect(Collectors.toList());
    }

    @Override
    protected List<BundleDependency> getBundleDependencies() {
        return this.bundleDependencies;
    }

    @Override
    protected File getProjectFolder() {
        return this.artifactLocation;
    }

    @Override
    protected ClassLoaderConfiguration.ClassLoaderConfigurationBuilder getClassLoaderConfigurationBuilder() {
        return new ClassLoaderConfiguration.ClassLoaderConfigurationBuilder();
    }

    @Override
    protected boolean shouldPopulateLocalPackages() {
        return !PluginLocalDependenciesDenylist.isDenylisted(this.bundleDependency.getDescriptor());
    }
}

