/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.activation.internal.classloader.AbstractArtifactClassLoaderConfigurationAssembler;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.ClassLoaderModelAssembler;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class PluginClassLoaderConfigurationAssembler
extends AbstractArtifactClassLoaderConfigurationAssembler {
    private final File artifactLocation;
    private final List<BundleDependency> bundleDependencies;
    private final BundleDescriptor bundleDescriptor;
    private final DeployableArtifactDescriptor ownerDescriptor;

    public PluginClassLoaderConfigurationAssembler(ArtifactCoordinates artifactCoordinates, List<BundleDependency> projectDependencies, Set<BundleDescriptor> sharedProjectDependencies, File artifactLocation, MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor, List<BundleDependency> bundleDependencies, BundleDescriptor bundleDescriptor, DeployableArtifactDescriptor ownerDescriptor) {
        super(new ClassLoaderModelAssembler(artifactCoordinates, projectDependencies, sharedProjectDependencies, muleArtifactLoaderDescriptor).createClassLoaderModel());
        this.artifactLocation = artifactLocation;
        this.bundleDependencies = bundleDependencies;
        this.bundleDescriptor = bundleDescriptor;
        this.ownerDescriptor = ownerDescriptor;
    }

    protected List<URL> addArtifactSpecificClassLoaderConfiguration(ClassLoaderModel.ClassLoaderModelBuilder classLoaderConfigurationBuilder) {
        ArrayList<URL> dependenciesArtifactsUrls = new ArrayList<URL>();
        if (this.ownerDescriptor != null) {
            this.ownerDescriptor.getClassLoaderModel().getDependencies().stream().filter(bundleDescriptor -> bundleDescriptor.getDescriptor().isPlugin()).filter(bundleDescriptor -> bundleDescriptor.getDescriptor().getGroupId().equals(this.bundleDescriptor.getGroupId()) && bundleDescriptor.getDescriptor().getArtifactId().equals(this.bundleDescriptor.getArtifactId())).filter(bundleDependency -> bundleDependency.getAdditionalDependenciesList() != null && !bundleDependency.getAdditionalDependenciesList().isEmpty()).forEach(bundleDependency -> this.processPluginAdditionalDependenciesURIs((BundleDependency)bundleDependency, classLoaderConfigurationBuilder).forEach(uri -> {
                URL dependencyArtifactUrl;
                try {
                    dependencyArtifactUrl = uri.toURL();
                }
                catch (MalformedURLException e) {
                    throw new ArtifactActivationException(I18nMessageFactory.createStaticMessage((String)String.format("There was an exception obtaining the URL for the artifact [%s], file [%s]", this.bundleDescriptor.getArtifactFileName(), uri)), e);
                }
                dependenciesArtifactsUrls.add(dependencyArtifactUrl);
            }));
        }
        return dependenciesArtifactsUrls;
    }

    private List<URI> processPluginAdditionalDependenciesURIs(BundleDependency bundleDependency, ClassLoaderModel.ClassLoaderModelBuilder classLoaderConfigurationBuilder) {
        return bundleDependency.getAdditionalDependenciesList().stream().map(additionalDependency -> {
            classLoaderConfigurationBuilder.withLocalPackages(additionalDependency.getPackages());
            classLoaderConfigurationBuilder.withLocalResources(additionalDependency.getResources());
            return additionalDependency.getBundleUri();
        }).collect(Collectors.toList());
    }

    @Override
    protected List<BundleDependency> getBundleDependencies() {
        return this.bundleDependencies;
    }

    @Override
    protected File getProjectFolder() {
        return this.artifactLocation;
    }

    @Override
    protected ClassLoaderModel.ClassLoaderModelBuilder getClassLoaderConfigurationBuilder() {
        return new ClassLoaderModel.ClassLoaderModelBuilder();
    }

    @Override
    protected boolean shouldPopulateLocalPackages() {
        return true;
    }
}

