/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.maven.client.internal.util.MavenUtils;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.activation.api.deployable.ArtifactModelResolver;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.utils.ArtifactUtils;
import org.mule.runtime.module.artifact.activation.internal.deployable.DeployablePluginsDependenciesResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.AdditionalPluginDependenciesResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.DeployableDependencyResolver;
import org.mule.runtime.module.artifact.activation.internal.plugin.Plugin;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tools.api.classloader.model.ApplicationGAVModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class MavenDeployableProjectModelBuilder
implements DeployableProjectModelBuilder {
    private static final String DEFAULT_PACKAGE_EXPORT = "";
    private static final String JAVA_EXTENSION = "java";
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String VERSION = "version";
    private static final String CLASS_PATH_SEPARATOR = "/";
    private static final String DEFAULT_SOURCES_DIRECTORY = "src/main";
    private static final String DEFAULT_SOURCES_JAVA_DIRECTORY = "/java";
    private static final String DEFAULT_RESOURCES_DIRECTORY = "/resources";
    private static final String DEFAULT_MULE_DIRECTORY = "/mule";
    private final File projectFolder;
    private final MavenConfiguration mavenConfiguration;
    private List<String> packages = Collections.emptyList();
    private List<String> resources = Collections.emptyList();
    private List<BundleDependency> deployableMavenBundleDependencies;
    private Map<ArtifactCoordinates, List<Artifact>> pluginsArtifactDependencies;
    private List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> deployableBundleDependencies;
    private Set<BundleDescriptor> sharedDeployableBundleDescriptors;
    private Map<BundleDescriptor, List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>> additionalPluginDependencies;
    private Map<BundleDescriptor, List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>> pluginsBundleDependencies;
    private File deployableArtifactRepositoryFolder;

    public MavenDeployableProjectModelBuilder(File projectFolder, MavenConfiguration mavenConfiguration) {
        this.projectFolder = projectFolder;
        this.mavenConfiguration = mavenConfiguration;
    }

    public MavenDeployableProjectModelBuilder(File projectFolder) {
        this(projectFolder, MavenDeployableProjectModelBuilder.getDefaultMavenConfiguration());
    }

    private static MavenConfiguration getDefaultMavenConfiguration() {
        MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)MavenDeployableProjectModelBuilder.class.getClassLoader());
        Supplier localMavenRepository = mavenClientProvider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier();
        SettingsSupplierFactory settingsSupplierFactory = mavenClientProvider.getSettingsSupplierFactory();
        Optional globalSettings = settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional userSettings = settingsSupplierFactory.environmentUserSettingsSupplier();
        Optional settingsSecurity = settingsSupplierFactory.environmentSettingsSecuritySupplier();
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().forcePolicyUpdateNever(true).localMavenRepositoryLocation((File)localMavenRepository.get());
        globalSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).globalSettingsLocation(arg_0));
        userSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).userSettingsLocation(arg_0));
        settingsSecurity.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        return mavenConfigurationBuilder.build();
    }

    @Override
    public DeployableProjectModel build() {
        File pom = this.getPomFromFolder(this.projectFolder);
        Model pomModel = MavenUtils.getPomModelFromFile((File)pom);
        this.deployableArtifactRepositoryFolder = this.mavenConfiguration.getLocalMavenRepositoryLocation();
        ArtifactCoordinates deployableArtifactCoordinates = this.getDeployableProjectArtifactCoordinates(pomModel);
        AetherMavenClient aetherMavenClient = new AetherMavenClient(this.mavenConfiguration);
        List<String> activeProfiles = this.mavenConfiguration.getActiveProfiles().orElse(Collections.emptyList());
        this.resolveDeployableDependencies(aetherMavenClient, pom, pomModel, activeProfiles);
        this.resolveDeployablePluginsData(this.deployableMavenBundleDependencies);
        this.resolveAdditionalPluginDependencies(aetherMavenClient, pomModel, activeProfiles, this.pluginsArtifactDependencies);
        try {
            this.getAvailablePackagesAndResources(pomModel.getBuild());
        }
        catch (IOException e) {
            throw new ArtifactActivationException(I18nMessageFactory.createStaticMessage((String)"Couldn't search exported packages and resources"), e);
        }
        return new DeployableProjectModel(this.packages, this.resources, this.buildBundleDescriptor(deployableArtifactCoordinates), this.getModelResolver(deployableArtifactCoordinates), this.projectFolder, this.deployableBundleDependencies, this.sharedDeployableBundleDescriptors, this.additionalPluginDependencies);
    }

    protected Supplier<MuleDeployableModel> getModelResolver(ArtifactCoordinates deployableArtifactCoordinates) {
        if (deployableArtifactCoordinates.getClassifier().equals("mule-application")) {
            return () -> ArtifactModelResolver.applicationModelResolver().resolve(this.projectFolder);
        }
        if (deployableArtifactCoordinates.getClassifier().equals("mule-domain")) {
            return () -> ArtifactModelResolver.domainModelResolver().resolve(this.projectFolder);
        }
        throw new IllegalStateException("project is not a mule-application or mule-domain");
    }

    private ArtifactCoordinates getDeployableProjectArtifactCoordinates(Model pomModel) {
        ApplicationGAVModel deployableGAVModel = new ApplicationGAVModel(pomModel.getGroupId(), pomModel.getArtifactId(), pomModel.getVersion());
        return ArtifactUtils.getDeployableArtifactCoordinates(pomModel, deployableGAVModel);
    }

    private void resolveDeployableDependencies(AetherMavenClient aetherMavenClient, File pom, Model pomModel, List<String> activeProfiles) {
        DeployableDependencyResolver deployableDependencyResolver = new DeployableDependencyResolver(aetherMavenClient);
        this.deployableMavenBundleDependencies = deployableDependencyResolver.resolveDeployableDependencies(pom, false, Optional.empty());
        List<Artifact> deployableArtifactDependencies = ArtifactUtils.updateArtifactsSharedState(this.deployableMavenBundleDependencies, ArtifactUtils.updatePackagesResources(ArtifactUtils.toApplicationModelArtifacts(this.deployableMavenBundleDependencies)), pomModel, activeProfiles);
        this.deployableBundleDependencies = deployableArtifactDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList());
        this.sharedDeployableBundleDescriptors = this.deployableBundleDependencies.stream().filter(bd -> deployableArtifactDependencies.stream().anyMatch(artifact -> artifact.isShared() && bd.getDescriptor().getGroupId().equals(artifact.getArtifactCoordinates().getGroupId()) && bd.getDescriptor().getArtifactId().equals(artifact.getArtifactCoordinates().getArtifactId()))).map(org.mule.runtime.module.artifact.api.descriptor.BundleDependency::getDescriptor).collect(Collectors.toSet());
    }

    private void resolveAdditionalPluginDependencies(AetherMavenClient aetherMavenClient, Model pomModel, List<String> activeProfiles, Map<ArtifactCoordinates, List<Artifact>> pluginsDependencies) {
        List<Plugin> initialAdditionalPluginDependencies = this.findArtifactPackagerPlugin(pomModel, activeProfiles).map(this::getAdditionalPluginDependencies).orElse(Collections.emptyList());
        AdditionalPluginDependenciesResolver additionalPluginDependenciesResolver = new AdditionalPluginDependenciesResolver(aetherMavenClient, initialAdditionalPluginDependencies, new File("temp"));
        this.additionalPluginDependencies = this.toPluginDependencies(additionalPluginDependenciesResolver.resolveDependencies(this.deployableMavenBundleDependencies, pluginsDependencies));
    }

    private void resolveDeployablePluginsData(List<BundleDependency> deployableMavenBundleDependencies) {
        this.pluginsArtifactDependencies = new DeployablePluginsDependenciesResolver().resolve(deployableMavenBundleDependencies);
        HashMap pluginsBundleDescriptors = new HashMap();
        this.pluginsArtifactDependencies.keySet().forEach(pluginArtifactCoordinates -> pluginsBundleDescriptors.put(pluginArtifactCoordinates, this.buildBundleDescriptor((ArtifactCoordinates)pluginArtifactCoordinates)));
        this.pluginsBundleDependencies = new HashMap<BundleDescriptor, List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>>();
        this.pluginsArtifactDependencies.forEach((pluginArtifactCoordinates, pluginDependencies) -> this.pluginsBundleDependencies.put((BundleDescriptor)pluginsBundleDescriptors.get(pluginArtifactCoordinates), pluginDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList())));
        this.deployableBundleDependencies = this.deployableBundleDependencies.stream().map(dbd -> new BundleDependency.Builder(dbd).setTransitiveDependencies(this.pluginsBundleDependencies.get(dbd.getDescriptor())).build()).collect(Collectors.toList());
    }

    private Map<BundleDescriptor, List<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>> toPluginDependencies(Map<BundleDependency, List<BundleDependency>> pluginsAndDependencies) {
        return pluginsAndDependencies.entrySet().stream().collect(Collectors.toMap(entry -> this.deployableBundleDependencies.stream().filter(bd -> bd.getDescriptor().getGroupId().equals(((BundleDependency)entry.getKey()).getDescriptor().getGroupId()) && bd.getDescriptor().getArtifactId().equals(((BundleDependency)entry.getKey()).getDescriptor().getArtifactId())).map(org.mule.runtime.module.artifact.api.descriptor.BundleDependency::getDescriptor).findAny().get(), entry -> {
            List<Artifact> deployableArtifactDependencies = ArtifactUtils.updatePackagesResources(ArtifactUtils.toApplicationModelArtifacts((List)entry.getValue()));
            return deployableArtifactDependencies.stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList());
        }));
    }

    private BundleDescriptor buildBundleDescriptor(ArtifactCoordinates artifactCoordinates) {
        return new BundleDescriptor.Builder().setArtifactId(artifactCoordinates.getArtifactId()).setGroupId(artifactCoordinates.getGroupId()).setVersion(artifactCoordinates.getVersion()).setBaseVersion(artifactCoordinates.getVersion()).setType(artifactCoordinates.getType()).setClassifier(artifactCoordinates.getClassifier()).build();
    }

    private void getAvailablePackagesAndResources(Build build) throws IOException {
        String sourceDirectory = build.getSourceDirectory() != null ? build.getSourceDirectory() : DEFAULT_SOURCES_DIRECTORY;
        Path javaDirectory = Paths.get(this.projectFolder.getAbsolutePath(), sourceDirectory.concat(DEFAULT_SOURCES_JAVA_DIRECTORY));
        List allJavaFiles = Files.walk(javaDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        Predicate<Path> isJavaFile = path -> FilenameUtils.getExtension((String)path.toString()).endsWith(JAVA_EXTENSION);
        this.packages = allJavaFiles.stream().filter(isJavaFile).map(path -> {
            Path parent = javaDirectory.relativize((Path)path).getParent();
            return parent != null ? parent.toString() : DEFAULT_PACKAGE_EXPORT;
        }).map(this::escapeSlashes).map(s -> s.replace(CLASS_PATH_SEPARATOR, PACKAGE_SEPARATOR)).distinct().collect(Collectors.toList());
        this.resources = build.getResources().isEmpty() ? this.getResourcesInFolder(sourceDirectory.concat(DEFAULT_RESOURCES_DIRECTORY)) : build.getResources().stream().flatMap(r -> {
            try {
                return this.getResourcesInFolder(r.getDirectory()).stream();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load files from" + r.getDirectory());
            }
        }).collect(Collectors.toList());
        this.resources.addAll(this.getResourcesInFolder(sourceDirectory.concat(DEFAULT_MULE_DIRECTORY)));
    }

    private List<String> getResourcesInFolder(String resourcesDirectoryName) throws IOException {
        Path resourcesDirectory = Paths.get(this.projectFolder.getAbsolutePath(), resourcesDirectoryName);
        List allResourcesFiles = Files.walk(resourcesDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        return allResourcesFiles.stream().map(resourcesDirectory::relativize).map(Path::toString).map(this::escapeSlashes).collect(Collectors.toList());
    }

    private String escapeSlashes(String p) {
        return p.replace("\\", CLASS_PATH_SEPARATOR);
    }

    private Function<Artifact, org.mule.runtime.module.artifact.api.descriptor.BundleDependency> createBundleDependencyFromPackagerDependency(Function<URI, URI> uriResolver) {
        return d -> {
            URI bundle = d.getUri();
            if (!d.getUri().isAbsolute()) {
                bundle = (URI)uriResolver.apply(d.getUri());
            }
            return new BundleDependency.Builder().setDescriptor(new BundleDescriptor.Builder().setArtifactId(d.getArtifactCoordinates().getArtifactId()).setGroupId(d.getArtifactCoordinates().getGroupId()).setClassifier(d.getArtifactCoordinates().getClassifier()).setType(d.getArtifactCoordinates().getType()).setVersion(d.getArtifactCoordinates().getVersion()).setBaseVersion(d.getArtifactCoordinates().getVersion()).build()).setBundleUri(bundle).setPackages(d.getPackages() == null ? Collections.emptySet() : Sets.newHashSet((Object[])d.getPackages())).setResources(d.getResources() == null ? Collections.emptySet() : Sets.newHashSet((Object[])d.getResources())).build();
        };
    }

    private Function<URI, URI> getDeployableArtifactRepositoryUriResolver() {
        return uri -> new File(this.deployableArtifactRepositoryFolder, uri.toString()).toURI();
    }

    private File getPomFromFolder(File projectFolder) {
        String pomFilePath = "pom.xml";
        File pomFile = new File(projectFolder, pomFilePath);
        Preconditions.checkState((boolean)pomFile.exists(), (String)String.format("The pom.xml file for artifact in folder %s could not be found", projectFolder.getAbsolutePath()));
        return pomFile;
    }

    protected Optional<org.apache.maven.model.Plugin> findArtifactPackagerPlugin(Model model, List<String> activeProfiles) {
        Stream basePlugin = Stream.empty();
        Build build = model.getBuild();
        if (build != null) {
            basePlugin = this.findArtifactPackagerPlugin(build.getPlugins()).map(Stream::of).orElse(Stream.empty());
        }
        List sortedActiveProfiles = activeProfiles.stream().sorted(String::compareTo).collect(Collectors.toList());
        Stream<org.apache.maven.model.Plugin> packagerConfigsForActivePluginsStream = model.getProfiles().stream().filter(profile -> sortedActiveProfiles.contains(profile.getId())).map(profile -> this.findArtifactPackagerPlugin(profile.getBuild() != null ? profile.getBuild().getPlugins() : null)).filter(plugin -> !plugin.equals(Optional.empty())).map(Optional::get);
        return Stream.concat(basePlugin, packagerConfigsForActivePluginsStream).reduce((p1, p2) -> {
            p1.setConfiguration((Object)Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)p2.getConfiguration()), (Xpp3Dom)((Xpp3Dom)p1.getConfiguration())));
            p1.getDependencies().addAll(p2.getDependencies());
            return p1;
        });
    }

    private Optional<org.apache.maven.model.Plugin> findArtifactPackagerPlugin(List<org.apache.maven.model.Plugin> plugins) {
        if (plugins != null) {
            return plugins.stream().filter(plugin -> plugin.getArtifactId().equals("mule-maven-plugin") && plugin.getGroupId().equals("org.mule.tools.maven") || plugin.getArtifactId().equals("mule-extensions-maven-plugin") && plugin.getGroupId().equals("org.mule.runtime.plugins")).findFirst();
        }
        return Optional.empty();
    }

    private List<Plugin> getAdditionalPluginDependencies(org.apache.maven.model.Plugin packagingPlugin) {
        Xpp3Dom[] pluginsDom;
        Xpp3Dom additionalPluginDependenciesDom;
        ArrayList<Plugin> pluginsAdditionalLibraries = new ArrayList<Plugin>();
        Object configuration = packagingPlugin.getConfiguration();
        if (configuration != null && (additionalPluginDependenciesDom = ((Xpp3Dom)configuration).getChild("additionalPluginDependencies")) != null && (pluginsDom = additionalPluginDependenciesDom.getChildren("plugin")) != null) {
            for (Xpp3Dom pluginDom : pluginsDom) {
                String pluginGroupId = this.getChildParameterValue(pluginDom, GROUP_ID, true);
                String pluginArtifactId = this.getChildParameterValue(pluginDom, ARTIFACT_ID, true);
                ArrayList<Dependency> additionalDependencyDependencies = new ArrayList<Dependency>();
                Xpp3Dom dependenciesDom = pluginDom.getChild("additionalDependencies");
                if (dependenciesDom != null) {
                    for (Xpp3Dom dependencyDom : dependenciesDom.getChildren("dependency")) {
                        Dependency dependency = new Dependency();
                        dependency.setGroupId(this.getChildParameterValue(dependencyDom, GROUP_ID, true));
                        dependency.setArtifactId(this.getChildParameterValue(dependencyDom, ARTIFACT_ID, true));
                        dependency.setVersion(this.getChildParameterValue(dependencyDom, VERSION, true));
                        String type = this.getChildParameterValue(dependencyDom, "type", false);
                        dependency.setType(type == null ? "jar" : type);
                        dependency.setClassifier(this.getChildParameterValue(dependencyDom, "classifier", false));
                        dependency.setSystemPath(this.getChildParameterValue(dependencyDom, "systemPath", false));
                        additionalDependencyDependencies.add(dependency);
                    }
                }
                Plugin plugin = new Plugin();
                plugin.setGroupId(pluginGroupId);
                plugin.setArtifactId(pluginArtifactId);
                plugin.setAdditionalDependencies(additionalDependencyDependencies);
                pluginsAdditionalLibraries.add(plugin);
            }
        }
        return pluginsAdditionalLibraries;
    }

    private String getChildParameterValue(Xpp3Dom element, String childName, boolean validate) {
        String childValue;
        Xpp3Dom child = element.getChild(childName);
        String string = childValue = child != null ? child.getValue() : null;
        if (StringUtils.isEmpty((CharSequence)childValue) && validate) {
            throw new IllegalArgumentException("Expecting child element with not null value " + childName);
        }
        return childValue;
    }
}

