/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.descriptor;

import java.io.File;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.module.artifact.activation.internal.ExecutionContext;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidator;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;

public abstract class AbstractArtifactDescriptorFactory<M extends AbstractMuleArtifactModel, T extends ArtifactDescriptor> {
    private final File artifactLocation;
    private M artifactModel;
    private final ArtifactDescriptorValidator artifactDescriptorValidator;

    public AbstractArtifactDescriptorFactory(File artifactLocation, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder) {
        this.artifactLocation = artifactLocation;
        this.artifactDescriptorValidator = artifactDescriptorValidatorBuilder.validateMinMuleVersion().validateMuleProduct().validateVersionFormat().build();
    }

    public T create() {
        this.artifactModel = this.createArtifactModel();
        this.validateModel(this.artifactModel);
        T descriptor = this.doCreateArtifactDescriptor();
        BundleDescriptor bundleDescriptor = this.getBundleDescriptor();
        descriptor.setBundleDescriptor(bundleDescriptor);
        descriptor.setMinMuleVersion(new MuleVersion(this.artifactModel.getMinMuleVersion()));
        descriptor.setRequiredProduct(this.artifactModel.getRequiredProduct());
        ClassLoaderModel classLoaderModel = this.getClassLoaderModel(this.artifactModel.getClassLoaderModelLoaderDescriptor());
        descriptor.setClassLoaderModel(classLoaderModel);
        this.doDescriptorConfig(descriptor);
        this.doValidation(descriptor);
        return descriptor;
    }

    private void validateModel(M artifactModel) {
        if (!ExecutionContext.isMuleFramework()) {
            artifactModel.validateModel(this.artifactLocation.getName());
        }
    }

    protected void doValidation(T descriptor) {
        if (!ExecutionContext.isMuleFramework()) {
            this.artifactDescriptorValidator.validate(descriptor);
        }
    }

    protected M getArtifactModel() {
        return this.artifactModel;
    }

    public File getArtifactLocation() {
        return this.artifactLocation;
    }

    protected abstract M createArtifactModel();

    protected abstract void doDescriptorConfig(T var1);

    protected abstract ClassLoaderModel getClassLoaderModel(MuleArtifactLoaderDescriptor var1);

    protected abstract BundleDescriptor getBundleDescriptor();

    protected abstract T doCreateArtifactDescriptor();
}

