/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.deployable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.utils.VersionUtils;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;

public class MulePluginsCompatibilityValidator {
    public Map<String, List<BundleDescriptor>> validate(List<BundleDescriptor> mulePlugins) {
        return this.buildDependencyMap(mulePlugins).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1 && !this.areMulePluginVersionCompatible((List)entry.getValue())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (List)e.getValue()));
    }

    private boolean areMulePluginVersionCompatible(List<BundleDescriptor> dependencies) {
        Set majors = dependencies.stream().map(BundleDescriptor::getVersion).map(VersionUtils::getMajor).collect(Collectors.toSet());
        return majors.size() <= 1;
    }

    private Map<String, List<BundleDescriptor>> buildDependencyMap(List<BundleDescriptor> dependencyList) {
        HashMap<String, List<BundleDescriptor>> dependencyMap = new HashMap<String, List<BundleDescriptor>>();
        for (BundleDescriptor plugin : dependencyList) {
            String pluginKey = plugin.getGroupId() + ":" + plugin.getArtifactId();
            dependencyMap.computeIfAbsent(pluginKey, k -> new ArrayList());
            ((List)dependencyMap.get(pluginKey)).add(plugin);
        }
        return dependencyMap;
    }
}

