/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.classloader.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.ClassLoaderModel;

public class ClassLoaderModelAssembler {
    protected static final String CLASS_LOADER_MODEL_VERSION = "1.2.0";
    private final ArtifactCoordinates artifactCoordinates;
    private final List<BundleDependency> projectDependencies;
    private final Set<BundleDescriptor> sharedProjectDependencies;
    private final List<String> availablePackages;
    private final List<String> availableResources;
    private final MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor;

    public ClassLoaderModelAssembler(ArtifactCoordinates artifactCoordinates, List<BundleDependency> projectDependencies, Set<BundleDescriptor> sharedProjectDependencies, List<String> availablePackages, List<String> availableResources, MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor) {
        this.artifactCoordinates = Objects.requireNonNull(artifactCoordinates);
        this.projectDependencies = Objects.requireNonNull(projectDependencies);
        this.sharedProjectDependencies = Objects.requireNonNull(sharedProjectDependencies);
        this.availablePackages = Objects.requireNonNull(availablePackages);
        this.availableResources = Objects.requireNonNull(availableResources);
        this.muleArtifactLoaderDescriptor = muleArtifactLoaderDescriptor;
    }

    public ClassLoaderModelAssembler(ArtifactCoordinates artifactCoordinates, List<BundleDependency> projectDependencies, Set<BundleDescriptor> sharedProjectDependencies, MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor) {
        this(artifactCoordinates, projectDependencies, sharedProjectDependencies, Collections.emptyList(), Collections.emptyList(), muleArtifactLoaderDescriptor);
    }

    public ClassLoaderModel createClassLoaderModel() {
        ClassLoaderModel classLoaderModel = new ClassLoaderModel(CLASS_LOADER_MODEL_VERSION, this.getArtifactCoordinates());
        this.assembleClassLoaderModel(classLoaderModel);
        return classLoaderModel;
    }

    protected final void assembleClassLoaderModel(ClassLoaderModel classLoaderModel) {
        classLoaderModel.setDependencies(this.toArtifacts(this.projectDependencies));
        classLoaderModel.setPackages(this.getExportedAttribute("exportedPackages", this.availablePackages, false));
        classLoaderModel.setResources(this.getExportedAttribute("exportedResources", this.availableResources, true));
    }

    private Artifact toArtifact(BundleDependency bundleDependency) {
        ArtifactCoordinates artifactCoordinates = this.toArtifactCoordinates(bundleDependency.getDescriptor());
        Artifact artifact = new Artifact(artifactCoordinates, bundleDependency.getBundleUri());
        artifact.setPackages(bundleDependency.getPackages() == null ? new String[]{} : bundleDependency.getPackages().toArray(new String[0]));
        artifact.setResources(bundleDependency.getResources() == null ? new String[]{} : bundleDependency.getResources().toArray(new String[0]));
        if (this.sharedProjectDependencies.contains(bundleDependency.getDescriptor())) {
            artifact.setShared(true);
        }
        return artifact;
    }

    protected List<Artifact> toArtifacts(List<BundleDependency> dependencies) {
        return dependencies.stream().map(this::toArtifact).collect(Collectors.toList());
    }

    private ArtifactCoordinates toArtifactCoordinates(BundleDescriptor bundleDescriptor) {
        return new ArtifactCoordinates(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), bundleDescriptor.getBaseVersion(), bundleDescriptor.getType(), (String)bundleDescriptor.getClassifier().orElse(null));
    }

    private String[] getExportedAttribute(String exportedAttributeName, List<String> defaultValue, boolean alwaysProvideDefault) {
        if (this.muleArtifactLoaderDescriptor != null) {
            Map originalAttributes = this.muleArtifactLoaderDescriptor.getAttributes();
            if (originalAttributes != null && originalAttributes.get(exportedAttributeName) != null) {
                return ((List)originalAttributes.get(exportedAttributeName)).toArray(new String[0]);
            }
            if (!alwaysProvideDefault) {
                return new String[0];
            }
        }
        return defaultValue.toArray(new String[0]);
    }

    protected ArtifactCoordinates getArtifactCoordinates() {
        return this.artifactCoordinates;
    }

    protected List<BundleDependency> getProjectDependencies() {
        return this.projectDependencies;
    }
}

