/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.api.ast;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.type.catalog.ApplicationTypeLoader;
import org.mule.runtime.core.api.util.boot.ExtensionLoaderUtils;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.module.artifact.activation.api.ast.AstXmlParserSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArtifactAstUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactAstUtils.class);
    private static final Set<TypedComponentIdentifier.ComponentType> APPLICATION_COMPONENT_TYPES = Collections.unmodifiableSet(EnumSet.of(TypedComponentIdentifier.ComponentType.OPERATION_DEF));

    public static ArtifactAst parseAndBuildAppExtensionModel(String[] configResources, AstXmlParserSupplier parserSupplier, Set<ExtensionModel> extensions, ArtifactType artifactType, boolean disableValidations, MuleContext muleContext) throws ConfigurationException {
        ExtensionModel artifactExtensionModel;
        ArtifactAst partialAst = ArtifactAstUtils.doParseArtifactIntoAst(configResources, parserSupplier, extensions, true);
        if (artifactType.equals((Object)ArtifactType.APPLICATION) && (artifactExtensionModel = (ExtensionModel)ArtifactAstUtils.parseArtifactExtensionModel(partialAst, muleContext.getExecutionClassLoader().getParent(), muleContext).orElse(null)) != null) {
            HashSet<ExtensionModel> enrichedExtensionModels = new HashSet<ExtensionModel>(extensions);
            enrichedExtensionModels.add(artifactExtensionModel);
            return ArtifactAstUtils.doParseArtifactIntoAst(configResources, parserSupplier, enrichedExtensionModels, disableValidations);
        }
        return disableValidations ? partialAst : ArtifactAstUtils.doParseArtifactIntoAst(configResources, parserSupplier, extensions, false);
    }

    public static Optional<ExtensionModel> parseArtifactExtensionModel(ArtifactAst ast, ClassLoader artifactClassLoader, MuleContext muleContext) {
        if (ast.topLevelComponentsStream().noneMatch(component -> APPLICATION_COMPONENT_TYPES.contains(component.getComponentType()))) {
            return Optional.empty();
        }
        Optional artifactCoordinates = muleContext.getConfiguration().getArtifactCoordinates();
        if (!artifactCoordinates.isPresent()) {
            ArtifactAstUtils.logModelNotGenerated("No version specified on muleContext", muleContext);
            return Optional.empty();
        }
        Optional loader = ExtensionLoaderUtils.getOptionalLoaderById((ClassLoader)ArtifactAstUtils.class.getClassLoader(), (String)"mule");
        if (loader.isPresent()) {
            return Optional.of(((ExtensionModelLoader)loader.get()).loadExtensionModel(ExtensionModelLoadingRequest.builder((ClassLoader)artifactClassLoader, (DslResolvingContext)DslResolvingContext.getDefault((Set)muleContext.getExtensionManager().getExtensions())).addParameter("version", (Object)((ArtifactCoordinates)artifactCoordinates.get()).getVersion()).addParameter("muleSDK.artifactAst", (Object)ast).addParameter("muleSDK.artifactDescriptor", (Object)muleContext.getConfiguration().getId()).addParameter("muleSDK.typeLoader", (Object)new ApplicationTypeLoader()).build()));
        }
        ArtifactAstUtils.logModelNotGenerated("Mule ExtensionModelLoader not found", muleContext);
        return Optional.empty();
    }

    private static ArtifactAst doParseArtifactIntoAst(String[] configResources, AstXmlParserSupplier parserSupplier, Set<ExtensionModel> extensions, boolean disableValidations) {
        try {
            return parserSupplier.getParser(extensions, disableValidations).parse(ArtifactAstUtils.loadConfigResources(configResources));
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private static ConfigResource[] loadConfigResources(String[] configs) throws ConfigurationException {
        try {
            ConfigResource[] artifactConfigResources = new ConfigResource[configs.length];
            for (int i = 0; i < configs.length; ++i) {
                artifactConfigResources[i] = new ConfigResource(configs[i]);
            }
            return artifactConfigResources;
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private static void logModelNotGenerated(String reason, MuleContext muleContext) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("ExtensionModel for app {} not generated: {}", (Object)muleContext.getConfiguration().getId(), (Object)reason);
        }
    }

    private ArtifactAstUtils() {
    }
}

