/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.extension.discovery;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.api.extension.RuntimeExtensionModelProvider;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelDiscoverer;
import org.mule.runtime.module.artifact.activation.internal.PluginsDependenciesProcessor;
import org.mule.runtime.module.artifact.activation.internal.extension.discovery.ExtensionModelGenerator;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;

public class DefaultExtensionModelDiscoverer
implements ExtensionModelDiscoverer {
    private final ExtensionModelGenerator extensionModelGenerator;

    public DefaultExtensionModelDiscoverer(ExtensionModelGenerator extensionModelGenerator) {
        this.extensionModelGenerator = extensionModelGenerator;
    }

    @Override
    public Set<ExtensionModel> discoverRuntimeExtensionModels() {
        return Collections.unmodifiableSet(new SpiServiceRegistry().lookupProviders(RuntimeExtensionModelProvider.class, Thread.currentThread().getContextClassLoader()).stream().map(RuntimeExtensionModelProvider::createExtensionModel).collect(Collectors.toSet()));
    }

    @Override
    public Set<ExtensionModel> discoverPluginsExtensionModels(ExtensionDiscoveryRequest discoveryRequest) {
        return Collections.unmodifiableSet(new HashSet(PluginsDependenciesProcessor.process(discoveryRequest.getArtifactPluginDescriptors(), discoveryRequest.isParallelDiscovery(), (extensions, artifactPlugin) -> {
            ExtensionModel extension;
            ImmutableSet dependencies = new HashSet();
            dependencies.addAll(extensions);
            dependencies.addAll(discoveryRequest.getParentArtifactExtensions());
            if (!dependencies.contains(MuleExtensionModelProvider.getExtensionModel())) {
                dependencies = ImmutableSet.builder().addAll((Iterable)extensions).addAll(this.discoverRuntimeExtensionModels()).build();
            }
            if ((extension = this.extensionModelGenerator.obtainExtensionModel(discoveryRequest, (ArtifactPluginDescriptor)artifactPlugin, (Set<ExtensionModel>)dependencies)) != null) {
                extensions.add(extension);
            }
        })));
    }
}

