/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.api.extension.discovery;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.module.artifact.activation.internal.extension.discovery.DefaultExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;

public interface ExtensionDiscoveryRequest {
    public static ExtensionDiscoveryRequestBuilder builder() {
        return new ExtensionDiscoveryRequestBuilder();
    }

    public List<ArtifactPluginDescriptor> getArtifactPluginDescriptors();

    public Set<ExtensionModel> getParentArtifactExtensions();

    public boolean isParallelDiscovery();

    public boolean isEnrichDescriptions();

    public static final class ExtensionDiscoveryRequestBuilder {
        private List<ArtifactPluginDescriptor> artifactPlugins;
        private Set<ExtensionModel> parentArtifactExtensions = Collections.emptySet();
        private boolean parallelDiscovery = false;
        private boolean enrichDescriptions = true;

        public ExtensionDiscoveryRequestBuilder setArtifactPlugins(List<ArtifactPluginDescriptor> artifactPlugins) {
            this.artifactPlugins = artifactPlugins;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setParentArtifactExtensions(Set<ExtensionModel> parentArtifactExtensions) {
            this.parentArtifactExtensions = parentArtifactExtensions;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setEnrichDescriptions(boolean enrichDescriptions) {
            this.enrichDescriptions = enrichDescriptions;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setParallelDiscovery(boolean parallelDiscovery) {
            this.parallelDiscovery = parallelDiscovery;
            return this;
        }

        public ExtensionDiscoveryRequest build() {
            return new DefaultExtensionDiscoveryRequest(this.artifactPlugins, this.parentArtifactExtensions, this.parallelDiscovery, this.enrichDescriptions);
        }
    }
}

